/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.server;

import com.jfinal.kit.FileKit;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import com.jfinal.server.IServer;
import itez.kit.EFile;
import itez.kit.server.Scanner;
import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.session.FileSessionDataStoreFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;

public class LocalServer
implements IServer {
    protected String webAppDir;
    protected int port;
    protected String context;
    protected int scanIntervalSeconds;
    protected boolean running = false;
    protected Server server;
    protected WebAppContext webApp;

    LocalServer(String webAppDir, int port, String context, int scanIntervalSeconds) {
        if (webAppDir == null) {
            throw new IllegalStateException("Invalid webAppDir of web server: " + webAppDir);
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port of web server: " + port);
        }
        if (StrKit.isBlank((String)context)) {
            throw new IllegalStateException("Invalid context of web server: " + context);
        }
        this.webAppDir = webAppDir;
        this.port = port;
        this.context = context;
        this.scanIntervalSeconds = scanIntervalSeconds;
    }

    public void start() {
        if (!this.running) {
            try {
                this.running = true;
                this.doStart();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                LogKit.error((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void stop() {
        if (this.running) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LogKit.error((String)e.getMessage(), (Throwable)e);
            }
            this.running = false;
        }
    }

    protected void doStart() {
        if (!LocalServer.available(this.port)) {
            throw new IllegalStateException("\u7aef\u53e3: " + this.port + " \u5df2\u88ab\u5360\u7528!");
        }
        this.deleteSessionData();
        System.out.println("\u5f00\u59cb\u542f\u52a8JWinner...");
        this.server = new Server();
        ServerConnector http = new ServerConnector(this.server);
        http.setPort(this.port);
        this.server.addConnector((Connector)http);
        this.setSslContext();
        this.webApp = new WebAppContext();
        this.webApp.setContextPath(this.context);
        this.webApp.setResourceBase(this.webAppDir);
        this.webApp.setDisplayName("EServer by Jetty");
        this.webApp.getSystemClasspathPattern().add("sun.");
        this.webApp.getSystemClasspathPattern().add("com.sun.");
        this.webApp.getSystemClasspathPattern().add("org.apache.");
        this.webApp.getSystemClasspathPattern().add("org.glassfish.");
        this.webApp.setConfigurationDiscovered(true);
        this.webApp.setParentLoaderPriority(true);
        this.webApp.setThrowUnavailableOnStartupException(true);
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.webApp.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.webApp.setMaxFormContentSize(0x8000000);
        this.webApp.setServer(this.server);
        this.setBaseResources();
        this.persistSession();
        this.server.setHandler((Handler)this.webApp);
        this.server.setStopAtShutdown(true);
        this.server.setDumpAfterStart(false);
        this.server.setDumpBeforeStop(false);
        this.setClassLoader();
        if (this.scanIntervalSeconds > 0) {
            Scanner scanner = new Scanner(PathKit.getRootClassPath(), this.scanIntervalSeconds){

                @Override
                public void onChange() {
                    try {
                        System.err.println("\n\u52a0\u8f7d\u6539\u52a8 ......");
                        LocalServer.this.webApp.stop();
                        LocalServer.this.setClassLoader();
                        LocalServer.this.webApp.start();
                        System.err.println("\u52a0\u8f7d\u6210\u529f (^_^)");
                    }
                    catch (Exception e) {
                        System.err.println("Error reconfiguring/restarting webapp after change in watched files");
                        LogKit.error((String)e.getMessage(), (Throwable)e);
                    }
                }
            };
            System.out.println("\u542f\u52a8\u4ee3\u7801\u70ed\u52a0\u8f7d\u76d1\u542c\u5668\uff0c\u626b\u63cf\u95f4\u9694\uff1a " + this.scanIntervalSeconds + " \u79d2");
            scanner.start();
        }
        try {
            System.out.println("\u542f\u52a8 Jetty Server " + Server.getVersion() + "\uff0c\u7aef\u53e3: " + this.port);
            this.server.start();
            System.out.println("\u542f\u52a8\u5b8c\u6210\uff0c\u6b22\u8fce\u4f7f\u7528 JWinner (^_^)");
            this.server.join();
        }
        catch (Exception e) {
            LogKit.error((String)e.getMessage(), (Throwable)e);
            System.exit(100);
        }
    }

    protected void setClassLoader() {
        this.webApp.setClassLoader(EFile.getClassLoader());
    }

    protected String getClassPath() {
        return System.getProperty("java.class.path");
    }

    protected void deleteSessionData() {
        try {
            FileKit.delete((File)new File(this.getStoreDir()));
        }
        catch (Exception e) {
            LogKit.logNothing((Throwable)e);
        }
    }

    protected String getStoreDir() {
        String storeDir = PathKit.getWebRootPath() + "/../../session_data" + this.context;
        if ("\\".equals(File.separator)) {
            storeDir = storeDir.replaceAll("/", "\\\\");
        }
        return storeDir;
    }

    protected void persistSession() {
        String storeDir = this.getStoreDir();
        FileSessionDataStoreFactory fsdsf = new FileSessionDataStoreFactory();
        fsdsf.setStoreDir(new File(storeDir));
        this.server.addBean((Object)fsdsf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean available(int port) {
        if (port <= 0) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u542f\u52a8\u7aef\u53e3: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LogKit.logNothing((Throwable)e);
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    LogKit.logNothing((Throwable)e);
                }
            }
        }
        return false;
    }

    protected void setBaseResources() {
        try {
            ArrayList<String> resources = new ArrayList<String>();
            resources.add(this.webAppDir);
            Enumeration<URL> urls = EFile.getClassLoader().getResources("META-INF/resources");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String type = url.getProtocol();
                if ("file".equals(type)) {
                    resources.add(url.getPath());
                    continue;
                }
                if (!"jar".equals(type)) continue;
                String jarPath = "jar:" + url.getPath();
                resources.add(jarPath);
            }
            String[] resourcesArr = resources.toArray(new String[resources.size()]);
            this.webApp.setBaseResource((Resource)new ResourceCollection(resourcesArr));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setSslContext() {
    }
}

