package itez.kit.fileup;

import java.io.File;
import java.util.List;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;

import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.EUid;

public class TencentImpl implements IFileUp {
	
	private String Url; //云盘域名
	private String SercertId; //AppID的SercertId
	private String SercertKey; //AppID的SercertKey
	private String Bucket; //存储桶别名，带AppId，例如：mybucket-1234567
	private String BZone; //存储区域别名，例如：ap-beijing
	
	public TencentImpl(){
		SercertId = EProp.TencentStoreSId;
		SercertKey = EProp.TencentStoreSKey;
		Bucket = EProp.TencentStoreBucket;
		BZone = EProp.TencentStoreZone;
		Url = EProp.TencentStoreUrl;
		
		if(!Url.endsWith("/")){
			Url += "/";
		}
	}
	
	@Override
	public String upload(File file, String subPath) {
		return upload(file, subPath, true);
	}
	
	@Override
	public String upload(File file, String subPath, boolean uuidName) {
		String FileSep = "/";
		String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
		String fileName = file.getName();
		String extName = fileName.substring(fileName.lastIndexOf("."));
		if(EStr.notEmpty(subPath)){
			if(subPath.startsWith(FileSep)) subPath = subPath.substring(1);
			if(!subPath.endsWith(FileSep)) subPath += FileSep;
		}
	    String key = String.format("%s%s%s%s", subPath, fileIndex, uuidName ? EUid.generator() : fileName, extName);
	    try {
	    	COSCredentials cred = new BasicCOSCredentials(SercertId, SercertKey);
	    	ClientConfig clientConfig = new ClientConfig(new Region(BZone));
	    	COSClient cosclient = new COSClient(cred, clientConfig);
			cosclient.putObject(Bucket, key, file);
			cosclient.shutdown();
			file.delete();
	        return Url + key;
	    }catch (Exception cle) {
	    	System.err.println(cle.toString());
	    }
	    return null;
	}

	@Override
	public List<FileItem> list(String subPath) {
		System.out.println("暂未实现！！！！！");
		return null;
	}

	@Override
	public boolean remove(String fileName) {
		System.out.println("暂未实现！！！！！");
		return false;
	}
	
	public static void main(String[] args) {
		TencentImpl fileio = new TencentImpl();
		File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
		String path = fileio.upload(file, "");
		System.out.println(path);
	}

}
