package itez.kit.cache;

import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.cache.ehredis.EhredisImpl;
import itez.kit.log.ELogBase;

public class ECacheFactory {

	private static final ELogBase log = ELog.log(ECacheFactory.class);
	public static final ECacheFactory me = new ECacheFactory();
	private ECacheFactory(){}
	
	private ICache cacheImpl = null;
	
	public ICache getCache(){
		if(this.cacheImpl == null){
			if(EProp.DevMode){
				this.cacheImpl = new NoCache();
				log.info("当前处于调试环境，自动关闭缓存！");
			}else{
				String cachePlan = EProp.CachePlan.toLowerCase();
				log.info("数据缓存方案：{}", cachePlan);
				if(cachePlan.equals("ehcache")){
					this.cacheImpl = new EhcacheImpl();
				}else if(cachePlan.equals("redis")){
					this.cacheImpl = new RedisImpl();
				}else if(cachePlan.equals("ehredis")){
					this.cacheImpl = new EhredisImpl();
				}
			}
		}
		return this.cacheImpl;
	}
	
}
