package itez.kit;

import org.apache.commons.lang3.ArrayUtils;

public class ESql {

	StringBuffer queryStr = new StringBuffer("");
	Object queryPara[] = new Object[]{};
	
	/**
	 * @category 构造方法
	 * @param sql
	 */
	public ESql(String sql){
		this.queryStr.append(sql);
	}
	
	/**
	 * @category 构造方法
	 * @param sql
	 * @param args
	 */
	public ESql(String sql, Object...args){
		this.queryStr.append(sql);
		this.queryPara = args;
	}
	
	/**
	 * @category 附加SQL语句
	 * @param sql
	 * @return
	 */
	public ESql add(String sql){
		this.queryStr.append(sql);
		return this;
	}
	
	/**
	 * @category 附加SQL语句
	 * @param sql
	 * @param args
	 * @return
	 */
	public ESql add(String sql, Object...args){
		this.queryStr.append(sql);
		this.queryPara = ArrayUtils.addAll(this.queryPara, args);
		return this;
	}
	
	/**
	 * 返回SQL语句
	 * @return
	 */
	public String getSql(){
		return this.queryStr.toString();
	}
	
	/**
	 * 返回SQL参数
	 * @return
	 */
	public Object[] getParas(){
		return this.queryPara;
	}
	
	@Override
	public String toString(){
		String sql = this.queryStr.toString();
		sql = String.format(sql.replaceAll("\\?", "'%s'"), this.queryPara);
		return sql;
	}
	
}
