/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.server;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import com.jfinal.server.Scanner;
import itez.kit.server.LocalServer;
import itez.kit.server.LocalServerClassLoader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class LocalServer_Jetty
extends LocalServer {
    private static Log log = Log.getLog(LocalServer_Jetty.class);
    protected Server server;
    protected WebAppContext context;
    protected Integer port = 80;
    protected String webAppDir = "src/main/webapp";
    protected String contextPath = "/";
    protected Integer scanIntervalSeconds = 0;
    private boolean running = false;

    public LocalServer_Jetty() {
        this.initServer();
    }

    public LocalServer_Jetty(Integer port) {
        this.port = port;
        this.initServer();
    }

    public LocalServer_Jetty(Integer port, String webAppDir) {
        this.port = port;
        this.webAppDir = webAppDir;
        this.initServer();
    }

    public LocalServer_Jetty(Integer port, String webAppDir, String contextPath) {
        this.port = port;
        this.webAppDir = webAppDir;
        this.contextPath = contextPath;
        this.initServer();
    }

    protected void initServer() {
        if (!this.available(this.port)) {
            throw new IllegalStateException("\u7aef\u53e3: " + this.port + " \u5df2\u88ab\u5360\u7528\uff01");
        }
        this.server = new Server(this.port.intValue());
        this.server.setStopAtShutdown(true);
        SslContextFactory scf = this.createSslContext();
        if (scf != null) {
            ServerConnector https_conn = new ServerConnector(this.server, scf);
            https_conn.setPort(443);
            https_conn.setIdleTimeout(30000L);
            https_conn.setAcceptQueueSize(100);
            this.server.addConnector((Connector)https_conn);
        }
        this.context = new WebAppContext();
        this.context.setContextPath(this.contextPath);
        this.context.setDisplayName("EServer by Jetty");
        this.context.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.context.setConfigurationDiscovered(true);
        this.context.setParentLoaderPriority(true);
        this.context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.context.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.context.setResourceBase(this.webAppDir);
        this.context.setServer(this.server);
        this.server.setHandler((Handler)this.context);
        this.setBaseResources();
        if (this.scanIntervalSeconds > 0) {
            this.changeClassLoader();
            Scanner scanner = new Scanner(PathKit.getRootClassPath(), this.scanIntervalSeconds){

                public void onChange() {
                    try {
                        log.info("\u52a0\u8f7d\u6539\u53d8\u7684\u4ee3\u7801...");
                        LocalServer_Jetty.this.context.stop();
                        LocalServer_Jetty.this.changeClassLoader();
                        LocalServer_Jetty.this.context.start();
                        log.info("\u66f4\u65b0\u5b8c\u6210\u3002");
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
            log.info("\u5f00\u542f\u4ee3\u7801\u53d8\u5316\u626b\u7801\u670d\u52a1\uff0c\u6bcf\u9694\uff1a" + this.scanIntervalSeconds + " \u79d2\u626b\u63cf\u4e00\u6b21\u3002");
            scanner.start();
        }
    }

    protected void setBaseResources() {
        try {
            ArrayList<String> resources = new ArrayList<String>();
            resources.add(this.webAppDir);
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("META-INF/resources");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String type = url.getProtocol();
                if ("file".equals(type)) {
                    resources.add(url.getPath());
                    continue;
                }
                if (!"jar".equals(type)) continue;
                String jarPath = "jar:" + url.getPath();
                resources.add(jarPath);
            }
            String[] resourcesArr = resources.toArray(new String[resources.size()]);
            this.context.setBaseResource((Resource)new ResourceCollection(resourcesArr));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected SslContextFactory createSslContext() {
        SslContextFactory scf = null;
        return scf;
    }

    @Override
    public boolean start() {
        if (!this.running) {
            try {
                this.server.start();
                this.running = true;
                log.info("EServer\u542f\u52a8\u6210\u529f\uff01");
            }
            catch (Throwable ex) {
                log.info("EServer\u542f\u52a8\u5931\u8d25\uff01");
                log.error(ex.toString(), ex);
                this.stop();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean restart() {
        if (this.running) {
            this.stop();
            this.start();
        }
        return true;
    }

    @Override
    public boolean stop() {
        if (this.running) {
            try {
                this.server.stop();
                this.running = false;
                log.info("EServer\u505c\u6b62\u6210\u529f\uff01");
            }
            catch (Exception ex) {
                log.info("EServer\u505c\u6b62\u5931\u8d25\uff01");
                log.error(ex.toString(), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getContext() {
        return this.context;
    }

    private void changeClassLoader() {
        try {
            String classPath = this.getClassPath();
            LocalServerClassLoader loader = new LocalServerClassLoader(this.context, classPath);
            this.context.setClassLoader((ClassLoader)((Object)loader));
        }
        catch (IOException e) {
            LogKit.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private String getClassPath() {
        return System.getProperty("java.class.path");
    }
}

