/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.fileup;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.fileup.FileItem;
import itez.kit.fileup.IFileUp;
import java.io.File;
import java.util.List;

public class TencentImpl
implements IFileUp {
    private String Url;
    private String SercertId = EProp.TencentStoreSId;
    private String SercertKey = EProp.TencentStoreSKey;
    private String Bucket = EProp.TencentStoreBucket;
    private String BZone = EProp.TencentStoreZone;

    public TencentImpl() {
        this.Url = EProp.TencentStoreUrl;
        if (!this.Url.endsWith("/")) {
            this.Url = this.Url + "/";
        }
    }

    @Override
    public String upload(File file, String subPath) {
        return this.upload(file, subPath, true);
    }

    @Override
    public String upload(File file, String subPath, boolean uuidName) {
        String FileSep = "/";
        String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
        String fileName = file.getName();
        String extName = fileName.substring(fileName.lastIndexOf("."));
        if (EStr.notEmpty(subPath)) {
            if (subPath.startsWith(FileSep)) {
                subPath = subPath.substring(1);
            }
            if (!subPath.endsWith(FileSep)) {
                subPath = subPath + FileSep;
            }
        }
        String key = String.format("%s%s%s%s", subPath, fileIndex, uuidName ? EUid.generator() : fileName, extName);
        try {
            BasicCOSCredentials cred = new BasicCOSCredentials(this.SercertId, this.SercertKey);
            ClientConfig clientConfig = new ClientConfig(new Region(this.BZone));
            COSClient cosclient = new COSClient((COSCredentials)cred, clientConfig);
            cosclient.putObject(this.Bucket, key, file);
            cosclient.shutdown();
            file.delete();
            return this.Url + key;
        }
        catch (Exception cle) {
            System.err.println(cle.toString());
            return null;
        }
    }

    @Override
    public List<FileItem> list(String subPath) {
        System.out.println("\u6682\u672a\u5b9e\u73b0\uff01\uff01\uff01\uff01\uff01");
        return null;
    }

    @Override
    public boolean remove(String fileName) {
        System.out.println("\u6682\u672a\u5b9e\u73b0\uff01\uff01\uff01\uff01\uff01");
        return false;
    }

    public static void main(String[] args) {
        TencentImpl fileio = new TencentImpl();
        File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
        String path = fileio.upload(file, "");
        System.out.println(path);
    }
}

