/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.fileup;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jfinal.kit.Ret;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.fileup.FileItem;
import itez.kit.fileup.IFileUp;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class QiNiuImpl
implements IFileUp {
    private String Url;
    private String AK = EProp.QiNiuStoreAK;
    private String SK = EProp.QiNiuStoreSK;
    private String Bucket = EProp.QiNiuStoreBucket;
    private String BZone = EProp.QiNiuStoreZone;

    public QiNiuImpl() {
        this.Url = EProp.QiNiuStoreUrl;
        if (!this.Url.endsWith("/")) {
            this.Url = this.Url + "/";
        }
    }

    @Override
    public String upload(File file, String subPath) {
        return this.upload(file, subPath, true);
    }

    @Override
    public String upload(File file, String subPath, boolean uuidName) {
        String FileSep = "/";
        String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
        String fileName = file.getName();
        String extName = fileName.substring(fileName.lastIndexOf("."));
        if (EStr.notEmpty(subPath)) {
            if (subPath.startsWith(FileSep)) {
                subPath = subPath.substring(1);
            }
            if (!subPath.endsWith(FileSep)) {
                subPath = subPath + FileSep;
            }
        }
        String key = uuidName ? String.format("%s%s%s%s", subPath, fileIndex, EUid.generator(), extName) : String.format("%s%s", subPath, fileName);
        Configuration cfg = new Configuration(StoreZone.find(this.BZone).zone);
        UploadManager uploadManager = new UploadManager(cfg);
        Auth auth = Auth.create((String)this.AK, (String)this.SK);
        String upToken = auth.uploadToken(this.Bucket);
        try {
            Response response = uploadManager.put(file, key, upToken);
            String retJson = response.bodyString();
            Ret ret = (Ret)JSON.parseObject((String)retJson, Ret.class);
            file.delete();
            return this.Url + ret.getStr((Object)"key");
        }
        catch (QiniuException ex) {
            Response r = ex.response;
            System.err.println(r.toString());
            try {
                System.err.println(r.bodyString());
            }
            catch (QiniuException qiniuException) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public List<FileItem> list(String subPath) {
        ArrayList temps = Lists.newArrayList();
        Configuration cfg = new Configuration(StoreZone.find(this.BZone).zone);
        Auth auth = Auth.create((String)this.AK, (String)this.SK);
        BucketManager bucketManager = new BucketManager(auth, cfg);
        String prefix = subPath;
        int limit = 1000;
        String delimiter = "";
        BucketManager.FileListIterator fileListIterator = bucketManager.createFileListIterator(this.Bucket, prefix, limit, delimiter);
        while (fileListIterator.hasNext()) {
            FileInfo[] items;
            for (FileInfo item : items = fileListIterator.next()) {
                FileItem temp = new FileItem();
                temp.setFileName(item.key.substring(item.key.lastIndexOf("/") + 1));
                temp.setFilePath(item.key);
                temp.setFileSize(item.fsize);
                temp.setMimeType(item.mimeType);
                temp.setUrl(this.Url + item.key);
                temps.add(temp);
            }
        }
        return temps;
    }

    @Override
    public boolean remove(String fileName) {
        Configuration cfg = new Configuration(StoreZone.find(this.BZone).zone);
        Auth auth = Auth.create((String)this.AK, (String)this.SK);
        BucketManager bucketManager = new BucketManager(auth, cfg);
        try {
            bucketManager.delete(this.Bucket, fileName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        QiNiuImpl fileio = new QiNiuImpl();
        File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
        String path = fileio.upload(file, "");
        System.out.println(path);
    }

    private static enum StoreZone {
        EastChina("\u534e\u4e1c"),
        NorthChina("\u534e\u5317"),
        SouthChina("\u534e\u5357"),
        NorthAmerica("\u5317\u7f8e"),
        Auto("");

        private String desc;
        private Zone zone;

        private StoreZone(String desc) {
            this.desc = desc;
            this.zone = this.desc.equals("\u534e\u4e1c") ? Zone.zone0() : (this.desc.equals("\u534e\u5317") ? Zone.zone1() : (this.desc.equals("\u534e\u5357") ? Zone.zone2() : (this.desc.equals("\u5317\u7f8e") ? Zone.zoneNa0() : Zone.autoZone())));
        }

        public static StoreZone find(String desc) {
            if (desc.equals("\u534e\u4e1c")) {
                return EastChina;
            }
            if (desc.equals("\u534e\u5317")) {
                return NorthChina;
            }
            if (desc.equals("\u534e\u5357")) {
                return SouthChina;
            }
            if (desc.equals("\u5317\u7f8e")) {
                return NorthAmerica;
            }
            return Auto;
        }
    }
}

