/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.fileup;

import com.google.common.collect.Lists;
import com.jfinal.kit.PathKit;
import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.ERegex;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.fileup.FileItem;
import itez.kit.fileup.IFileUp;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class LocalImpl
implements IFileUp {
    private String Url;
    private String DiskPath = EProp.LocalFilePath;
    private static final String FileSep = File.separator;

    public LocalImpl() {
        this.Url = EProp.LocalFileUrl;
        if (!this.Url.endsWith("/")) {
            this.Url = this.Url + "/";
        }
        this.DiskPath = this.formatPath(this.DiskPath);
        if (!(this.DiskPath.startsWith("/") || this.DiskPath.startsWith("\\") || ERegex.has(this.DiskPath, "^[A-Za-z]\\:"))) {
            this.DiskPath = PathKit.getWebRootPath() + FileSep + this.DiskPath;
        }
        if (!this.DiskPath.endsWith(FileSep)) {
            this.DiskPath = this.DiskPath + FileSep;
        }
    }

    @Override
    public String upload(File file, String subPath) {
        return this.upload(file, subPath, true);
    }

    @Override
    public String upload(File file, String subPath, boolean uuidName) {
        String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
        String fileName = file.getName();
        String extName = fileName.substring(fileName.lastIndexOf("."));
        if (EStr.notEmpty(subPath)) {
            if (subPath.startsWith(FileSep)) {
                subPath = subPath.substring(1);
            }
            if (!subPath.endsWith(FileSep)) {
                subPath = subPath + FileSep;
            }
        }
        String key = uuidName ? String.format("%s%s%s%s", subPath, fileIndex, EUid.generator(), extName) : String.format("%s%s", subPath, fileName);
        try {
            String dest = this.formatPath(this.DiskPath + key);
            String toPathStr = dest.substring(0, dest.lastIndexOf(FileSep));
            File toPath = new File(toPathStr);
            if (!toPath.exists()) {
                toPath.mkdirs();
            }
            Files.move(file.toPath(), new File(dest).toPath(), new CopyOption[0]);
            return this.Url + key;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return null;
        }
    }

    private String formatPath(String path) {
        return path.replace("/", FileSep).replace("\\", FileSep);
    }

    @Override
    public List<FileItem> list(String subPath) {
        ArrayList temps = Lists.newArrayList();
        String root = this.formatPath(this.DiskPath + subPath);
        File dir = new File(root);
        if (!dir.exists()) {
            return temps;
        }
        if (dir.isFile()) {
            return temps;
        }
        File[] list = dir.listFiles();
        if (list == null || list.length == 0) {
            return temps;
        }
        for (File file : list) {
            if (file.isDirectory()) continue;
            FileItem temp = new FileItem();
            temp.setFileName(file.getName());
            temp.setFilePath(file.getAbsolutePath());
            temp.setFileSize(file.length());
            temp.setMimeType(temp.getExtName());
            String url = file.getAbsolutePath().substring(this.DiskPath.length()).replace(File.separator, "/");
            temp.setUrl(this.Url + url);
            temps.add(temp);
        }
        return temps;
    }

    @Override
    public boolean remove(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return file.delete();
    }

    public static void main(String[] args) {
        LocalImpl fileio = new LocalImpl();
        File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
        String path = fileio.upload(file, "");
        System.out.println(path);
    }
}

