/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.cache;

import com.jfinal.plugin.ehcache.IDataLoader;
import itez.kit.ELog;
import itez.kit.cache.ICache;
import itez.kit.log.ELogBase;
import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;

public class EhcacheImpl
implements ICache {
    private static final ELogBase log = ELog.log(EhcacheImpl.class);
    private CacheManager cacheManager;
    private static Object locker = new Object();
    private CacheEventListener cacheEventListener;

    public EhcacheImpl() {
        System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
        this.cacheManager = CacheManager.create();
        log.info("\u521b\u5efa\u9ed8\u8ba4CacheManager");
    }

    public EhcacheImpl(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getOrAddCache(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            Object object = locker;
            synchronized (object) {
                cache = this.cacheManager.getCache(cacheName);
                if (cache == null) {
                    log.warn("\u672a\u627e\u5230CacheName\uff1a{}\uff0c\u5c06\u81ea\u52a8\u521b\u5efa\u8be5Cache\u3002", cacheName);
                    this.cacheManager.addCacheIfAbsent(cacheName);
                    cache = this.cacheManager.getCache(cacheName);
                }
            }
        }
        return cache;
    }

    @Override
    public boolean has(String cacheName, Object key) {
        Cache cache = this.getOrAddCache(cacheName);
        return cache.isKeyInCache(key) && cache.getQuiet(key) != null;
    }

    public <T> T get(String cacheName, Object key) {
        Element element = this.getOrAddCache(cacheName).get(key);
        return (T)(element != null ? element.getObjectValue() : null);
    }

    public void put(String cacheName, Object key, Object value) {
        this.put(cacheName, key, value, 0);
    }

    @Override
    public void put(String cacheName, Object key, Object value, Integer liveSeconds) {
        Element element = new Element(key, value);
        if (liveSeconds > 0) {
            element.setTimeToIdle(liveSeconds.intValue());
        }
        this.getOrAddCache(cacheName).put(element);
    }

    public void remove(String cacheName, Object key) {
        this.getOrAddCache(cacheName).remove(key);
    }

    public void removeAll(String cacheName) {
        this.getOrAddCache(cacheName).removeAll();
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data);
        }
        return data;
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, Integer liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data, liveSeconds);
        }
        return data;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        Element element = this.getOrAddCache(cacheName).get(key);
        return element != null ? Integer.valueOf(element.getTimeToLive()) : null;
    }

    @Override
    public void setTtl(String cacheName, Object key, Integer seconds) {
        Element element = this.getOrAddCache(cacheName).get(key);
        if (element == null) {
            return;
        }
        element.setTimeToIdle(seconds.intValue());
        this.getOrAddCache(cacheName).put(element);
    }

    @Override
    public Set<String> getKeys(String cacheName) {
        return new HashSet<String>(this.getOrAddCache(cacheName).getKeys());
    }

    public CacheEventListener getCacheEventListener() {
        return this.cacheEventListener;
    }

    public void setCacheEventListener(CacheEventListener cacheEventListener) {
        this.cacheEventListener = cacheEventListener;
    }
}

