/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import itez.kit.EStr;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;

public final class EUid {
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int MACHINE_IDENTIFIER = EUid.createMachineIdentifier();
    private static final short PROCESS_IDENTIFIER = EUid.createProcessIdentifier();
    private static long timestamp;
    private static int counter;

    public static final synchronized String generator() {
        long t = System.currentTimeMillis();
        if (t == timestamp) {
            if (++counter >= 1679615) {
                counter = 1;
            }
        } else {
            Random rand = new Random(t);
            counter = rand.nextInt(1679615);
            timestamp = t;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EStr.addPrefix(Long.toString(t / 1000L, 35), 8, "zzzzzzzz"));
        sb.append(EStr.addPrefix(Long.toString(MACHINE_IDENTIFIER + PROCESS_IDENTIFIER, 36), 6));
        sb.append(EStr.addPrefix(Integer.toString(counter, 36), 4));
        return sb.toString().replace("-", "_").toUpperCase();
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                ByteBuffer bb = ByteBuffer.wrap(mac);
                try {
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (Throwable t) {
            machinePiece = new SecureRandom().nextInt();
        }
        return machinePiece &= 0xFFFFFF;
    }

    private static short createProcessIdentifier() {
        short processId;
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            processId = processName.contains("@") ? (short)Integer.parseInt(processName.substring(0, processName.indexOf(64))) : (short)ManagementFactory.getRuntimeMXBean().getName().hashCode();
        }
        catch (Throwable t) {
            processId = (short)new SecureRandom().nextInt();
        }
        return processId;
    }

    public static Date parseUuid(String tmuid) {
        if (tmuid.length() < 8) {
            return null;
        }
        String s = tmuid.substring(0, 8).toLowerCase();
        long l = Long.parseLong(s.replace("z", "0").replace("_", "-"), 35) * 1000L;
        return new Date(l);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 20; ++i) {
            System.out.println(EUid.generator());
        }
    }

    static {
        counter = 0;
    }
}

