/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EStr {
    public static final String Encoding = "UTF-8";
    public static final String FileSep = File.separator;
    private static final String PREFIX_STRING_ZERO = "0000000000";
    public static final Charset GBK = Charset.forName("GBK");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static boolean isNull(Object para) {
        return null == para;
    }

    public static boolean hasNull(Object ... paras) {
        if (paras == null) {
            return true;
        }
        for (Object para : paras) {
            if (para != null) continue;
            return true;
        }
        return false;
    }

    public static boolean allNull(Object ... paras) {
        if (paras == null) {
            return true;
        }
        for (Object para : paras) {
            if (para == null) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object para) {
        return !EStr.isNull(para);
    }

    public static Object ifNull(Object str, Object defaultStr) {
        return EStr.isNull(str) ? defaultStr : str;
    }

    public static boolean isEmpty(String str) {
        return null == str || str.equals("");
    }

    public static boolean hasEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String str : strings) {
            if (!EStr.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean allEmpty(String ... strings) {
        if (strings == null) {
            return true;
        }
        for (String str : strings) {
            if (!EStr.notEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean notEmpty(String str) {
        return !EStr.isEmpty(str);
    }

    public static boolean notEmpty(Object obj) {
        return obj == null ? false : EStr.notEmpty(obj.toString());
    }

    public static String ifEmpty(String str, String defaultStr) {
        return EStr.isEmpty(str) ? defaultStr : str;
    }

    public static String left(String str, int count) {
        return EStr.isNull(str) ? "" : (count < str.length() ? str.substring(0, count) : str);
    }

    public static String right(String str, int count) {
        if (EStr.isNull(str)) {
            return "";
        }
        int len = str.length();
        if (len < count) {
            return str;
        }
        return str.substring(len - count);
    }

    public static String addPrefix(int number, int len) {
        return EStr.addPrefix(number + "", len, PREFIX_STRING_ZERO);
    }

    public static String addPrefix(String str, int len) {
        return EStr.addPrefix(str, len, PREFIX_STRING_ZERO);
    }

    public static String addPrefix(String str, int len, String prefix) {
        str = prefix + str;
        return EStr.right(str, len);
    }

    public static String toLowerCaseFirst(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirst(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String parseArray(List<String> list) {
        return EStr.parseArray(list.toArray(new String[list.size()]), ",");
    }

    public static String parseArray(String[] arr) {
        return EStr.parseArray(arr, ",");
    }

    public static String parseArray(String[] arr, String sept) {
        if (arr == null) {
            return "";
        }
        return Arrays.stream(arr).collect(Collectors.joining(sept));
    }

    public static String[] toArray(String str) {
        return EStr.toArray(str, ",");
    }

    public static String[] toArray(String str, String sept) {
        return str.replace(" ", "").split(sept);
    }

    public static String ida2sqlIn(Object ... ida) {
        return Arrays.stream(ida).map(id -> String.format("'%s'", id.toString().trim())).collect(Collectors.joining(","));
    }

    public static String ida2sqlIn(String ... ida) {
        return Arrays.stream(ida).map(id -> String.format("'%s'", id.trim())).collect(Collectors.joining(","));
    }

    public static String ids2sqlIn(String ids) {
        String format = "'%s'";
        return String.format(format, ids.replace(" ", "").replace(",", "','"));
    }

    public static int findInArr(String[] arr, String keyword) {
        int ind = -1;
        for (String item : arr) {
            ++ind;
            if (!item.equals(keyword)) continue;
            return ind;
        }
        return -1;
    }

    public static String findUseful(Object ... objects) {
        return Arrays.stream(objects).filter(EStr::notEmpty).findFirst().orElse("").toString();
    }

    public static byte[] toByte(String str) {
        if (str == null) {
            return null;
        }
        return str.getBytes(UTF_8);
    }

    public static String parse(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, UTF_8);
    }
}

