/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class ERegex {
    public static final String ENCODING = "UTF-8";
    public static final String PATTERN_NUM_ALL = "^-?\\d+(\\.\\d+)?$";
    public static final String PATTERN_NUM_INT = "^-?\\d+$";
    public static final String PATTERN_NUM_INT1 = "^\\d+$";
    public static final String PATTERN_EMAIL = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
    public static final String PATTERN_IP_ADDRESS = "^\\d{1,3}(\\.\\d{1,3}){3}$";
    public static final String PATTERN_FIXED_PHONE = "^\\d{3}-\\d{8} ?\\d{4}-\\d{7}$";
    public static final String PATTERN_MOBILE_PHONE = "^1[0-9]{10}$";
    public static final String PATTERN_LOGIN_NAME = "^[a-zA-Z][a-zA-Z0-9_.]{2,15}$";
    public static final String PATTERN_QQ = "^[1-9][0-9]{4,}$";
    public static final String PATTERN_POST_CODE = "^[1-9]\\d{5}(?!\\d)$";
    public static final String PATTERN_ID_CARD = "(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$)";
    public static final String PATTERN_VARIABLE = "^[A-Za-z_]+\\w+$";
    public static final String PATTERN_CHINESE = "[\\u4e00-\\u9fa5]";
    public static final String PATTERN_DOUBLE_BYTE = "[^\\x00-\\xff]";

    public static boolean has(String str, String pattern) {
        Pattern keywordPattern = Pattern.compile(pattern);
        Matcher matcher = keywordPattern.matcher(str);
        return matcher.find();
    }

    public static boolean check(String str, String pattern) {
        Pattern keywordPattern = Pattern.compile(pattern);
        Matcher matcher = keywordPattern.matcher(str);
        return matcher.matches();
    }

    public static String find(String str, String pattern) {
        Pattern keywordPattern = Pattern.compile(pattern);
        Matcher matcher = keywordPattern.matcher(str);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static String findFirst(String str, String pattern) {
        Pattern keywordPattern = Pattern.compile(pattern);
        Matcher matcher = keywordPattern.matcher(str);
        if (matcher.find() && matcher.groupCount() > 0) {
            return matcher.group(1);
        }
        return null;
    }

    public static String[] findAll(String str, String pattern) {
        Pattern keywordPattern = Pattern.compile(pattern);
        Matcher matcher = keywordPattern.matcher(str);
        ArrayList<String> group = new ArrayList<String>();
        while (matcher.find()) {
            int size = matcher.groupCount();
            for (int i = 1; i <= size; ++i) {
                group.add(matcher.group(i));
            }
        }
        return group.toArray(new String[group.size()]);
    }

    public static boolean checkNumber(String num) {
        return true;
    }

    public static boolean checkIP(String ip) {
        return ERegex.check(ip, PATTERN_IP_ADDRESS);
    }

    public static boolean checkEmail(String email) {
        return ERegex.has(email, PATTERN_EMAIL);
    }

    public static boolean checkMobilePhone(String phone) {
        return ERegex.has(phone, PATTERN_MOBILE_PHONE);
    }

    public static boolean checkLoginName(String loginName) {
        return ERegex.has(loginName, PATTERN_LOGIN_NAME);
    }

    public static boolean checkVar(String var) {
        return ERegex.has(var, PATTERN_VARIABLE);
    }

    public static String encode(String data) throws Exception {
        byte[] b = Base64.encodeBase64URLSafe((byte[])data.getBytes(ENCODING));
        return new String(b, ENCODING);
    }

    public static String decode(String data) throws Exception {
        byte[] b = Base64.decodeBase64((byte[])data.getBytes(ENCODING));
        return new String(b, ENCODING);
    }

    public static String urlEncode(String source) {
        String result = source;
        try {
            result = URLEncoder.encode(source, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static void main(String[] args) {
        String str = "aa123aaaaaaa456aaaabbbb000weaea999sss";
        String ptn = "[a-z]{2}(\\d+)";
        String ret = ERegex.find(str, ptn);
        System.out.println(ret);
        String retf = ERegex.findFirst(str, ptn);
        System.out.println(retf);
        Object[] rets = ERegex.findAll(str, ptn);
        if (rets != null) {
            System.out.println(Arrays.toString(rets));
        }
    }
}

