/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class EImageResize {
    public static void resize(String imgSrc, String distSrc, Integer distWidth, Integer distHeight, boolean skipToBig) throws Exception {
        File file = new File(imgSrc);
        if (!file.exists()) {
            throw new Exception("\u539f\u56fe\u4e0d\u5b58\u5728\uff01");
        }
        BufferedImage src = ImageIO.read(file);
        int width = 100;
        int height = 100;
        if (null == distWidth && null == distHeight) {
            throw new Exception("\u81f3\u5c11\u4f20\u5165\u5bbd\u5ea6\u548c\u9ad8\u5ea6\u4e2d\u7684\u4e00\u9879");
        }
        if (null != distWidth && null != distHeight) {
            width = distWidth;
            height = distHeight;
        } else {
            int oldWidth = ((Image)src).getWidth(null);
            int oldHeight = ((Image)src).getHeight(null);
            if (null != distWidth) {
                if (distWidth >= oldWidth && skipToBig) {
                    return;
                }
                width = distWidth;
                height = oldHeight * width / oldWidth;
            } else {
                if (distHeight >= oldHeight && skipToBig) {
                    return;
                }
                height = distHeight;
                width = oldWidth * height / oldHeight;
            }
        }
        BufferedImage dist = new BufferedImage(width, height, 5);
        dist.getGraphics().drawImage(src, 0, 0, width, height, null);
        FileOutputStream out = new FileOutputStream(distSrc);
        ImageIO.write((RenderedImage)dist, "jpg", out);
        out.close();
    }

    public static void resizeWidth(String imgSrc, String distSrc, int distWidth) throws Exception {
        EImageResize.resize(imgSrc, distSrc, distWidth, null, false);
    }

    public static void resizeHeight(String imgSrc, String distSrc, int distHeight) throws Exception {
        EImageResize.resize(imgSrc, distSrc, null, distHeight, false);
    }

    public static void main(String[] args) {
    }
}

