/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import itez.kit.EStr;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ECookie {
    public static final int MAX_AGE_HALF_HOUR = 1800;
    public static final int MAX_AGE_WEEK = 604800;
    public static final int MAX_AGE_MONTH = 2592000;
    public static final int MAX_AGE_YEAR = 31536000;

    private static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        Map<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            cookieMap = Arrays.stream(cookies).collect(Collectors.toMap(Cookie::getName, c -> c));
        }
        return cookieMap;
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxValues, TimeUnit unit) {
        if (EStr.isEmpty(name)) {
            return;
        }
        if (EStr.isNull(value)) {
            value = "";
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (maxValues == 0) {
            cookie.setMaxAge(1800);
        } else {
            cookie.setMaxAge((int)unit.toSeconds(maxValues));
        }
        response.addCookie(cookie);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Map<String, Cookie> map = ECookie.readCookieMap(request);
        if (map.containsKey(name)) {
            String val = map.get(name).getValue();
            if (val != null) {
                return val.toString();
            }
            return null;
        }
        return null;
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        Map<String, Cookie> map = ECookie.readCookieMap(request);
        if (map.containsKey(name)) {
            Cookie cookie = map.get(name);
            cookie.setValue(null);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }
}

