/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import itez.kit.EClass;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class EClassSearch {
    public static void main(String[] args) {
    }

    public static Set<Class<?>> getClassList(String packageName, boolean includeChild, Class<? extends Annotation> annoClazz) {
        return EClassSearch.getClassList(packageName, includeChild, null, annoClazz, null);
    }

    public static Set<Class<?>> getClassList(String packageName, boolean includeChild, Class<?> supperClazz, Class<? extends Annotation> annoClazz) {
        return EClassSearch.getClassList(packageName, includeChild, supperClazz, annoClazz, null);
    }

    public static Set<Class<?>> getClassList(String packageName, boolean includeChild, Class<?> supperClazz, Class<? extends Annotation> annoClazz, HashSet<String> skipPackage) {
        HashSet clazzList = new HashSet();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            String strFile = packageName.replaceAll("\\.", "/");
            Enumeration<URL> urls = loader.getResources(strFile);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String type = url.getProtocol();
                String pkgPath = url.getPath();
                if ("file".equals(type)) {
                    EClassSearch.findClassByFile(clazzList, packageName, pkgPath, includeChild, supperClazz, annoClazz, skipPackage);
                    continue;
                }
                if (!"jar".equals(type)) continue;
                EClassSearch.findClassByJar(clazzList, packageName, url, includeChild, supperClazz, annoClazz, skipPackage);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return clazzList;
    }

    public static void findClassByFile(Set<Class<?>> clazzList, String packageName, String packagePath, boolean includeChild, Class<?> supperClazz, Class<? extends Annotation> annoClazz, HashSet<String> skipPackage) {
        if (clazzList == null) {
            return;
        }
        File[] files = EClassSearch.filterClassFiles(packagePath);
        if (files != null) {
            for (File f : files) {
                String fileName = f.getName();
                String filePath = f.getPath();
                if (skipPackage != null && skipPackage.stream().filter(s -> filePath.indexOf(s.replace(".", File.separator)) >= 0).count() > 0L) continue;
                if (f.isFile()) {
                    String clazzName = EClassSearch.getClassName(packageName, fileName);
                    EClassSearch.addClassName(clazzList, clazzName, supperClazz, annoClazz);
                    continue;
                }
                if (!includeChild) continue;
                String subPackageName = packageName + "." + fileName;
                String subPackagePath = packagePath + "/" + fileName;
                EClassSearch.findClassByFile(clazzList, subPackageName, subPackagePath, true, supperClazz, annoClazz, skipPackage);
            }
        }
    }

    public static void findClassByJar(Set<Class<?>> clazzList, String packageName, URL url, boolean includeChild, Class<?> supperClazz, Class<? extends Annotation> annoClazz, HashSet<String> skipPackage) throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        String packagePath = packageName.replace(".", "/");
        while (jarEntries.hasMoreElements()) {
            String prefix_name;
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.startsWith(packagePath) || !jarEntryName.endsWith(".class") || skipPackage != null && skipPackage.stream().filter(s -> jarEntryName.replace("/", ".").startsWith((String)s)).count() > 0L) continue;
            String clazzName = jarEntryName.replace("/", ".");
            int endIndex = clazzName.lastIndexOf(".");
            String prefix = null;
            if (endIndex > 0 && (endIndex = (prefix_name = clazzName.substring(0, endIndex)).lastIndexOf(".")) > 0) {
                prefix = prefix_name.substring(0, endIndex);
                clazzName = prefix_name.substring(endIndex);
            }
            if (prefix == null) continue;
            clazzName = prefix + clazzName;
            if (prefix.equals(packageName)) {
                EClassSearch.addClassName(clazzList, clazzName, supperClazz, annoClazz);
                continue;
            }
            if (!includeChild || !prefix.startsWith(packageName)) continue;
            EClassSearch.addClassName(clazzList, clazzName, supperClazz, annoClazz);
        }
    }

    private static File[] filterClassFiles(String packagePath) {
        if (packagePath == null) {
            return null;
        }
        return new File(packagePath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".class") || file.isDirectory();
            }
        });
    }

    private static String getClassName(String packageName, String fileName) {
        int endIndex = fileName.lastIndexOf(".");
        String clazz = null;
        if (endIndex >= 0) {
            clazz = fileName.substring(0, endIndex);
        }
        String clazzName = null;
        if (clazz != null) {
            clazzName = packageName + "." + clazz;
        }
        return clazzName;
    }

    private static void addClassName(Set<Class<?>> clazzList, String clazzName, Class<?> supperClazz, Class<? extends Annotation> annoClazz) {
        Class<?> clazz;
        if (clazzList != null && clazzName != null && (clazz = EClass.loadClass(clazzName)) != null) {
            if (supperClazz != null && !supperClazz.isAssignableFrom(clazz)) {
                return;
            }
            if (annoClazz != null && !clazz.isAnnotationPresent(annoClazz)) {
                return;
            }
            clazzList.add(clazz);
        }
    }
}

