package itez.kit.server;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import com.jfinal.server.Scanner;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

import java.io.IOException;
//import java.util.List;
//import java.util.ArrayList;
//import org.eclipse.jetty.util.resource.ResourceCollection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class LocalServer_Jetty extends LocalServer {

    private static Log log = Log.getLog(LocalServer_Jetty.class);

    protected Server server;
    protected WebAppContext context;
    
    protected Integer port = 80;
    protected String webAppDir = "src/main/webapp";
    protected String contextPath = "/";
    
    protected Integer scanIntervalSeconds = 0;
	private boolean running = false;

    public LocalServer_Jetty() {
        initServer();
    }

    public LocalServer_Jetty(Integer port) {
    	this.port = port;
        initServer();
    }

    public LocalServer_Jetty(Integer port, String webAppDir) {
    	this.port = port;
    	this.webAppDir = webAppDir;;
        initServer();
    }

    public LocalServer_Jetty(Integer port, String webAppDir, String contextPath) {
    	this.port = port;
    	this.webAppDir = webAppDir;
    	this.contextPath = contextPath;
        initServer();
    }

    protected void initServer() {
		if (!available(port)) throw new IllegalStateException("端口: " + port + " 已被占用！");
    	
        server = new Server(port);
        server.setStopAtShutdown(true);

        SslContextFactory scf = createSslContext();
        if(scf != null){
            ServerConnector https_conn = new ServerConnector(server, scf);
            https_conn.setPort(443);
    		https_conn.setIdleTimeout(30000);
    		https_conn.setAcceptQueueSize(100);
            server.addConnector(https_conn);
        }

        context = new WebAppContext();
        context.setContextPath(contextPath);
        context.setDisplayName("EServer by Jetty");
        context.setClassLoader(Thread.currentThread().getContextClassLoader());
        context.setConfigurationDiscovered(true);
        context.setParentLoaderPriority(true);
        context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        context.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        context.setResourceBase(webAppDir);
        context.setServer(server);
        server.setHandler(context);
        
        setBaseResources();
        
        if(scanIntervalSeconds > 0){
            changeClassLoader();
    		Scanner scanner = new Scanner(PathKit.getRootClassPath(), scanIntervalSeconds) {
    			public void onChange() {
    				try {
    					log.info("加载改变的代码...");
    					context.stop();
    		            changeClassLoader();
    					context.start();
    					log.info("更新完成。");
    				} catch (Exception e) {
    					log.error(e.getMessage(), e);
    				}
    			}
    		};
    		log.info("开启代码变化扫码服务，每隔：" + scanIntervalSeconds + " 秒扫描一次。");
    		scanner.start();
        }
    }
    
    protected void setBaseResources() {
		try {
			List<String> resources = new ArrayList<String>();
			resources.add(webAppDir);
			Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("META-INF/resources");
			while (urls.hasMoreElements()) {
				URL url = urls.nextElement();
                if (url != null) {
                	String type = url.getProtocol();
                	if("file".equals(type)){
                		resources.add(url.getPath());
                	}else if("jar".equals(type)){
                		String jarPath = "jar:" + url.getPath();
                		resources.add(jarPath);
                	}
                }
			}
			String[] resourcesArr = resources.toArray(new String[resources.size()]);
			context.setBaseResource(new ResourceCollection(resourcesArr));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
    
    /**
     * 需要启用SSL时，请覆盖该方法
     * @return
     */
    protected SslContextFactory createSslContext(){
		SslContextFactory scf = null;
		/*
		scf = new SslContextFactory();
        scf.setKeyStorePath("*.pfx文件路径");
        scf.setKeyStoreType("PKCS12");
        scf.setKeyStorePassword("密码");
        scf.setNeedClientAuth(false);
        */
        return scf;
    }

    @Override
	public boolean start() {
		if (!running) {
	        try {
	            server.start();
	            running = true;
	            log.info("EServer启动成功！");
	        } catch (Throwable ex) {
	            log.info("EServer启动失败！");
	            log.error(ex.toString(), ex);
	            stop();
	            return false;
	        }
		}
        return true;
    }

    @Override
    public boolean restart() {
		if (running) {
	        stop();
	        start();
		}
        return true;
    }

    @Override
    public boolean stop() {
		if (running) {
	        try {
	            server.stop();
	            running = false;
	            log.info("EServer停止成功！");
	        } catch (Exception ex) {
	            log.info("EServer停止失败！");
	            log.error(ex.toString(), ex);
	            return false;
	        }
		}
        return true;
    }

    public Server getServer() {
        return server;
    }

    public WebAppContext getContext() {
        return context;
    }

	private void changeClassLoader() {
		try {
			String classPath = getClassPath();
			LocalServerClassLoader loader = new LocalServerClassLoader(context, classPath);
			context.setClassLoader(loader);
		} catch (IOException e) {
			LogKit.error(e.getMessage(), e);
		}
	}
	
	private String getClassPath() {
		return System.getProperty("java.class.path");
	}

}
