package itez.kit.server;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;

import com.jfinal.kit.LogKit;

public abstract class LocalServer {

    public abstract boolean start();

    public abstract boolean restart();

    public abstract boolean stop();
    
	protected boolean available(int port) {
		if (port <= 0) throw new IllegalArgumentException("无效的端口号: " + port);
		ServerSocket ss = null;
		DatagramSocket ds = null;
		try {
			ss = new ServerSocket(port);
			ss.setReuseAddress(true);
			ds = new DatagramSocket(port);
			ds.setReuseAddress(true);
			return true;
		} catch (IOException e) {
			LogKit.logNothing(e);
		} finally {
			if (ds != null) ds.close();			
			if (ss != null) {
				try {
					ss.close();
				} catch (IOException e) {
					LogKit.logNothing(e);
				}
			}
		}
		return false;
	}

}
