package itez.kit.json;

import itez.kit.EStr;

/**
 * 该类提供格式化JSON字符串的方法。 该类的方法formatJson将JSON字符串格式化，方便查看JSON数据
 */
public class EJsonFomat {
	
	private final static String TAB_SPACE_HOLD = "                                                                ";
	private final static Integer TAB_SPACE_COUNT = 4;

	/**
	 * 格式化JSON字符串。
	 * 
	 * @param json 未格式化的JSON字符串。
	 * @return 格式化的JSON字符串。
	 */
	public static String format(String json) {
		StringBuffer result = new StringBuffer();
		int length = json.length();
		int number = 0;
		char key = 0;
		for (int i = 0; i < length; i++) {
			key = json.charAt(i);
			if ((key == '[') || (key == '{')) {
				result.append(key);
				result.append('\n');
				number++;
				result.append(indent(number));
				continue;
			}else if ((key == ']') || (key == '}')) {
				result.append('\n');
				number--;
				result.append(indent(number));
				result.append(key);
				if (((i + 1) < length) && (json.charAt(i + 1) != ',')) {
					result.append('\n');
				}
				continue;
			}else if ((key == ',')) {
				result.append(key);
				result.append('\n');
				result.append(indent(number));
				continue;
			}
			result.append(key);
		}
		return result.toString();
	}

	/**
	 * 压缩JSON字符串。
	 * 
	 * @param json 格式化的JSON字符串。
	 * @return 压缩后的JSON字符串。
	 */
	public static String compress(String json) {
		if(EStr.isEmpty(json)) return json;
		return json.replaceAll("\\s*|\\t|\\r|\\n", "").replace("\\n", "");
	}

	/**
	 * 返回指定次数的缩进字符串
	 * @param number 缩进次数。
	 * @return 指定缩进次数的字符串。
	 */
	private static String indent(int tabCount) {
		return TAB_SPACE_HOLD.substring(0, tabCount * TAB_SPACE_COUNT);
	}
}
