package itez.kit.guice;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MyMethodInterceptor implements MethodInterceptor {

	@Override
	public Object invoke(MethodInvocation invocation) throws Throwable {
		doBefore();
		Object ret = invocation.proceed();
		doAfter();
		return ret;
	}

	public void doBefore() {
		System.out.println("我是在方法之前要做的事情");
	}

	public void doAfter() {
		System.out.println("我是在方法执行之后做的事情");
	}

}
