package itez.kit.fileup;

import itez.kit.EStr;

public class FileItem {

	private String fileName;
	private String filePath;
	private String fileSize;
	private String mimeType;
	private String url;
	
	public String getFileName() {
		return fileName;
	}
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}
	public String getFileSize() {
		return fileSize;
	}
	public void setFileSize(Long space) {
		int x = 1024 * 1024;
		String spaceStr;
		if(space < 1024){
			spaceStr = String.format("%s %s", space, "Byte");
		}else if(space < x){
			spaceStr = String.format("%s %s", space / 1024, "KB");
		}else{
			spaceStr = String.format("%s %s", space / x, "MB");
		}
		this.fileSize = spaceStr;
	}
	public String getMimeType() {
		return mimeType;
	}
	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}
	public String getExtName(){
		if(EStr.isEmpty(fileName)) return "";
		return fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase();
	}
	public String getFilePath() {
		return filePath;
	}
	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	
}
