package itez.kit;

import java.util.HashMap;
import java.util.Map;

import com.jfinal.json.Json;

/**
 * ERet 用于返回值封装，也用于服务端与客户端的 json 数据通信
 * 
 * @author netwild
 *
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
public class ERet extends HashMap {

	private static final long serialVersionUID = -4023551444791419962L;

	private static final String STATE = "state";
	private static final String STATE_OK = "ok";
	private static final String STATE_FAIL = "fail";
	public static final String ATTR_MSG = "msg";

	/**
	 * 创建空对象
	 */
	public ERet() {
		
	}

	/**
	 * 创建空对象，静态方法
	 * @return
	 */
	public static ERet create() {
		return new ERet();
	}

	/**
	 * 创建实例，同时初始化一个键值对儿
	 * 
	 * @param key
	 * @param value
	 * @return
	 */
	public static ERet create(Object key, Object value) {
		return new ERet().set(key, value);
	}

	/**
	 * 创建实例，同时设置状态标识为成功
	 * @return
	 */
	public static ERet ok() {
		return new ERet().setOk();
	}

	/**
	 * 创建实例，同时设置状态标识为成功，并且传入信息描述
	 * @param msg
	 * @return
	 */
	public static ERet ok(String msg) {
		return ok().set(ATTR_MSG, msg);
	}

	/**
	 * 创建实例，同时设置状态标识为成功，同时初始化一个键值对儿
	 * @param key
	 * @param value
	 * @return
	 */
	public static ERet ok(Object key, Object value) {
		return ok().set(key, value);
	}

	/**
	 * 创建实例，同时设置状态标识为失败
	 * @return
	 */
	public static ERet fail() {
		return new ERet().setFail();
	}

	/**
	 * 创建实例，同时设置状态标识为失败，并且传入信息描述
	 * @param msg
	 * @return
	 */
	public static ERet fail(String msg) {
		return fail().set(ATTR_MSG, msg);
	}

	/**
	 * 创建实例，同时设置状态标识为失败，同时初始化一个键值对儿
	 * @param key
	 * @param value
	 * @return
	 */
	public static ERet fail(Object key, Object value) {
		return fail().set(key, value);
	}

	/**
	 * 设置状态标识为成功
	 * @return
	 */
	public ERet setOk() {
		super.put(STATE, STATE_OK);
		return this;
	}

	/**
	 * 设置状态标识为失败
	 * @return
	 */
	public ERet setFail() {
		super.put(STATE, STATE_FAIL);
		return this;
	}
	
	/**
	 * 设置描述信息
	 * @param msg
	 * @return
	 */
	public ERet setMsg(String msg){
		super.put(ATTR_MSG, msg);
		return this;
	}
	
	/**
	 * 返回描述信息
	 * @return
	 */
	public String getMsg(){
		return getAs(ATTR_MSG);
	}

	/**
	 * 返回状态标识是否为成功
	 * @return
	 */
	public boolean isOk() {
		Object state = get(STATE);
		if (STATE_OK.equals(state)) {
			return true;
		}
		if (STATE_FAIL.equals(state)) {
			return false;
		}
		throw new IllegalStateException("调用 isOk() 之前，必须先调用 ok()、fail() 或者 setOk()、setFail() 方法");
	}

	/**
	 * 返回状态标识是否为失败
	 * @return
	 */
	public boolean isFail() {
		Object state = get(STATE);
		if (STATE_FAIL.equals(state)) {
			return true;
		}
		if (STATE_OK.equals(state)) {
			return false;
		}

		throw new IllegalStateException("调用 isFail() 之前，必须先调用 ok()、fail() 或者 setOk()、setFail() 方法");
	}

	/**
	 * 添加键值对儿
	 * @param key
	 * @param value
	 * @return
	 */
	public ERet set(Object key, Object value) {
		super.put(key, value);
		return this;
	}

	/**
	 * 添加Map
	 * @param map
	 * @return
	 */
	public ERet set(Map map) {
		super.putAll(map);
		return this;
	}

	/**
	 * 添加ERet
	 * @param ret
	 * @return
	 */
	public ERet set(ERet ret) {
		super.putAll(ret);
		return this;
	}

	/**
	 * 删除指定键值
	 * @param key
	 * @return
	 */
	public ERet delete(Object key) {
		super.remove(key);
		return this;
	}

	/**
	 * 返回指定键值，泛型
	 * @param key
	 * @return
	 */
	public <T> T getAs(Object key) {
		return (T) get(key);
	}

	public String getStr(Object key) {
		Object s = get(key);
		return s != null ? s.toString() : null;
	}

	public Integer getInt(Object key) {
		Number n = (Number) get(key);
		return n != null ? n.intValue() : null;
	}

	public Long getLong(Object key) {
		Number n = (Number) get(key);
		return n != null ? n.longValue() : null;
	}

	public Number getNumber(Object key) {
		return (Number) get(key);
	}

	public Boolean getBoolean(Object key) {
		return (Boolean) get(key);
	}

	/**
	 * 转换为JSON格式
	 * @return
	 */
	public String toJson() {
		return Json.getJson().toJson(this);
	}
	
	/**
	 * 从JSON转换为ERet
	 * @param json
	 * @return
	 */
	public static ERet parse(String json){
		return EJson.parse(json, ERet.class);
	}

}
