/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.server;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import com.jfinal.server.Scanner;
import itez.kit.server.LocalServer;
import itez.kit.server.LocalServerClassLoader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class LocalServer_Jetty
extends LocalServer {
    private static Log log = Log.getLog(LocalServer_Jetty.class);
    protected Server server;
    protected WebAppContext context;
    protected Integer port = 80;
    protected String webAppDir = "src/main/webapp";
    protected String contextPath = "/";
    protected Integer scanIntervalSeconds = 0;
    private boolean running = false;

    public LocalServer_Jetty() {
    }

    public LocalServer_Jetty(Integer port) {
        this.port = port;
    }

    public LocalServer_Jetty(Integer port, String webAppDir) {
        this.port = port;
        this.webAppDir = webAppDir;
    }

    public LocalServer_Jetty(Integer port, String webAppDir, String contextPath) {
        this.port = port;
        this.webAppDir = webAppDir;
    }

    @Override
    public boolean start() {
        if (!this.running) {
            try {
                this.initServer();
                this.server.start();
                this.running = false;
                log.info("EServer\u542f\u52a8\u6210\u529f\uff01");
            }
            catch (Throwable ex) {
                log.info("EServer\u542f\u52a8\u5931\u8d25\uff01");
                log.error(ex.toString(), ex);
                this.stop();
                return false;
            }
        }
        return true;
    }

    protected void initServer() {
        this.server = new Server(this.port.intValue());
        this.server.setStopAtShutdown(true);
        SslContextFactory scf = new SslContextFactory();
        scf.setKeyStorePath("D:/JavaHome/cert/debug_itez_com_cn/214294696650114.pfx");
        scf.setKeyStoreType("PKCS12");
        scf.setKeyStorePassword("214294696650114");
        scf.setNeedClientAuth(false);
        ServerConnector https_conn = new ServerConnector(this.server, scf);
        https_conn.setPort(443);
        https_conn.setIdleTimeout(30000L);
        https_conn.setAcceptQueueSize(100);
        this.server.addConnector((Connector)https_conn);
        this.context = new WebAppContext();
        this.context.setContextPath(this.contextPath);
        this.context.setDisplayName("EServer by Jetty");
        this.context.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.context.setConfigurationDiscovered(true);
        this.context.setParentLoaderPriority(true);
        this.context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        this.context.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.context.setServer(this.server);
        this.context.setResourceBase(this.webAppDir);
        this.setBaseResources(this.webAppDir);
        this.server.setHandler((Handler)this.context);
        if (this.scanIntervalSeconds > 0) {
            this.changeClassLoader(this.context);
            Scanner scanner = new Scanner(PathKit.getRootClassPath(), this.scanIntervalSeconds){

                public void onChange() {
                    try {
                        log.info("\n\u52a0\u8f7d\u6539\u53d8\u7684\u4ee3\u7801...");
                        LocalServer_Jetty.this.context.stop();
                        LocalServerClassLoader loader = new LocalServerClassLoader(LocalServer_Jetty.this.context, LocalServer_Jetty.this.getClassPath());
                        LocalServer_Jetty.this.context.setClassLoader((ClassLoader)((Object)loader));
                        LocalServer_Jetty.this.context.start();
                        log.info("\u66f4\u65b0\u5b8c\u6210\u3002");
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            };
            log.info("\u5f00\u542f\u4ee3\u7801\u53d8\u5316\u626b\u7801\u670d\u52a1\uff0c\u6bcf\u9694\uff1a" + this.scanIntervalSeconds + " \u79d2\u626b\u63cf\u4e00\u6b21\u3002");
            scanner.start();
        }
    }

    protected void setBaseResources(String webAppDir) {
        try {
            ArrayList<String> resources = new ArrayList<String>();
            resources.add(webAppDir);
            String[] resourcesArr = resources.toArray(new String[resources.size()]);
            this.context.setBaseResource((Resource)new ResourceCollection(resourcesArr));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean restart() {
        if (this.running) {
            this.stop();
            this.start();
        }
        return true;
    }

    @Override
    public boolean stop() {
        if (this.running) {
            try {
                this.server.stop();
                this.running = false;
                log.info("EServer\u505c\u6b62\u6210\u529f\uff01");
            }
            catch (Exception ex) {
                log.info("EServer\u505c\u6b62\u5931\u8d25\uff01");
                log.error(ex.toString(), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public Server getServer() {
        return this.server;
    }

    public WebAppContext getContext() {
        return this.context;
    }

    private void changeClassLoader(WebAppContext webApp) {
        try {
            String classPath = this.getClassPath();
            LocalServerClassLoader jfcl = new LocalServerClassLoader(webApp, classPath);
            webApp.setClassLoader((ClassLoader)((Object)jfcl));
        }
        catch (IOException e) {
            LogKit.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private String getClassPath() {
        return System.getProperty("java.class.path");
    }
}

