/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.fileup;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.EUid;
import itez.kit.fileup.IFileUp;
import java.io.File;

public class TencentImpl
implements IFileUp {
    private String Url;
    private String SercertId = EProp.TencentStoreSId;
    private String SercertKey = EProp.TencentStoreSKey;
    private String Bucket = EProp.TencentStoreBucket;
    private String BZone = EProp.TencentStoreZone;

    public TencentImpl() {
        this.Url = EProp.TencentStoreUrl;
        if (!this.Url.endsWith("/")) {
            this.Url = this.Url + "/";
        }
    }

    @Override
    public String upload(File file) {
        String fileName = file.getName();
        String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
        String extName = fileName.substring(fileName.lastIndexOf("."));
        String key = String.format("%s%s%s", fileIndex, EUid.generator(), extName);
        try {
            BasicCOSCredentials cred = new BasicCOSCredentials(this.SercertId, this.SercertKey);
            ClientConfig clientConfig = new ClientConfig(new Region(this.BZone));
            COSClient cosclient = new COSClient((COSCredentials)cred, clientConfig);
            cosclient.putObject(this.Bucket, key, file);
            cosclient.shutdown();
            return this.Url + key;
        }
        catch (Exception cle) {
            System.err.println(cle.toString());
            return null;
        }
    }

    public static void main(String[] args) {
        TencentImpl fileio = new TencentImpl();
        File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
        String path = fileio.upload(file);
        System.out.println(path);
    }
}

