/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.fileup;

import com.alibaba.fastjson.JSON;
import com.jfinal.kit.Ret;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.EUid;
import itez.kit.fileup.IFileUp;
import java.io.File;

public class QiNiuImpl
implements IFileUp {
    private String Url;
    private String AK = EProp.QiNiuStoreAK;
    private String SK = EProp.QiNiuStoreSK;
    private String Bucket = EProp.QiNiuStoreBucket;
    private String BZone = EProp.QiNiuStoreZone;

    public QiNiuImpl() {
        this.Url = EProp.QiNiuStoreUrl;
        if (!this.Url.endsWith("/")) {
            this.Url = this.Url + "/";
        }
    }

    @Override
    public String upload(File file) {
        String fileName = file.getName();
        String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
        String extName = fileName.substring(fileName.lastIndexOf("."));
        String key = String.format("%s%s%s", fileIndex, EUid.generator(), extName);
        Configuration cfg = new Configuration(StoreZone.find(this.BZone).zone);
        UploadManager uploadManager = new UploadManager(cfg);
        Auth auth = Auth.create((String)this.AK, (String)this.SK);
        String upToken = auth.uploadToken(this.Bucket);
        try {
            Response response = uploadManager.put(file, key, upToken);
            String retJson = response.bodyString();
            Ret ret = (Ret)JSON.parseObject((String)retJson, Ret.class);
            return this.Url + ret.getStr((Object)"key");
        }
        catch (QiniuException ex) {
            Response r = ex.response;
            System.err.println(r.toString());
            try {
                System.err.println(r.bodyString());
            }
            catch (QiniuException qiniuException) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        QiNiuImpl fileio = new QiNiuImpl();
        File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
        String path = fileio.upload(file);
        System.out.println(path);
    }

    private static enum StoreZone {
        EastChina("\u534e\u4e1c"),
        NorthChina("\u534e\u5317"),
        SouthChina("\u534e\u5357"),
        NorthAmerica("\u5317\u7f8e"),
        Auto("");

        private String desc;
        private Zone zone;

        private StoreZone(String desc) {
            this.desc = desc;
            this.zone = this.desc.equals("\u534e\u4e1c") ? Zone.zone0() : (this.desc.equals("\u534e\u5317") ? Zone.zone1() : (this.desc.equals("\u534e\u5357") ? Zone.zone2() : (this.desc.equals("\u5317\u7f8e") ? Zone.zoneNa0() : Zone.autoZone())));
        }

        public static StoreZone find(String desc) {
            if (desc.equals("\u534e\u4e1c")) {
                return EastChina;
            }
            if (desc.equals("\u534e\u5317")) {
                return NorthChina;
            }
            if (desc.equals("\u534e\u5357")) {
                return SouthChina;
            }
            if (desc.equals("\u5317\u7f8e")) {
                return NorthAmerica;
            }
            return Auto;
        }
    }
}

