/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.fileup;

import com.jfinal.kit.PathKit;
import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.ERegex;
import itez.kit.EUid;
import itez.kit.fileup.IFileUp;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;

public class LocalImpl
implements IFileUp {
    private String Url;
    private String DiskPath = EProp.LocalFilePath;
    private static final String FileSep = File.separator;

    public LocalImpl() {
        this.Url = EProp.LocalFileUrl;
        if (!this.Url.endsWith("/")) {
            this.Url = this.Url + "/";
        }
        this.DiskPath = this.formatPath(this.DiskPath);
        if (!(this.DiskPath.startsWith("/") || this.DiskPath.startsWith("\\") || ERegex.has(this.DiskPath, "^[A-Za-z]\\:"))) {
            this.DiskPath = PathKit.getWebRootPath() + FileSep + this.DiskPath;
        }
        if (!this.DiskPath.endsWith(FileSep)) {
            this.DiskPath = this.DiskPath + FileSep;
        }
    }

    @Override
    public String upload(File file) {
        String fileName = file.getName();
        String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
        String extName = fileName.substring(fileName.lastIndexOf("."));
        String key = String.format("%s%s%s", fileIndex, EUid.generator(), extName);
        try {
            String dest = this.formatPath(this.DiskPath + key);
            String toPathStr = dest.substring(0, dest.lastIndexOf(FileSep));
            File toPath = new File(toPathStr);
            if (!toPath.exists()) {
                toPath.mkdirs();
            }
            Files.move(file.toPath(), new File(dest).toPath(), new CopyOption[0]);
            return this.Url + key;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            return null;
        }
    }

    private String formatPath(String path) {
        return path.replace("/", FileSep).replace("\\", FileSep);
    }

    public static void main(String[] args) {
        LocalImpl fileio = new LocalImpl();
        File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
        String path = fileio.upload(file);
        System.out.println(path);
    }
}

