/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.cache.ehredis;

import com.jfinal.plugin.ehcache.IDataLoader;
import itez.kit.ELog;
import itez.kit.EUid;
import itez.kit.cache.EhcacheImpl;
import itez.kit.cache.ICache;
import itez.kit.cache.RedisImpl;
import itez.kit.cache.ehredis.EhredisMessage;
import itez.kit.log.ELogBase;
import itez.kit.serializer.ESerializerFactory;
import itez.kit.serializer.ISerializer;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import redis.clients.jedis.BinaryJedisPubSub;

public class EhredisImpl
implements ICache,
CacheEventListener {
    private static final ELogBase log = ELog.log(EhredisImpl.class);
    private EhcacheImpl ehcache;
    private RedisImpl redis;
    private String channel = "jwinner_ehredis_channel";
    private String clientId = EUid.generator();
    private ISerializer serializer = ESerializerFactory.me.getSerializer();

    public EhredisImpl() {
        this.ehcache = new EhcacheImpl();
        this.ehcache.setCacheEventListener(this);
        this.redis = new RedisImpl();
        this.redis.subscribe(new BinaryJedisPubSub(){

            public void onMessage(byte[] channel, byte[] message) {
                EhredisImpl.this.onMessage((String)EhredisImpl.this.serializer.deserialize(channel), EhredisImpl.this.serializer.deserialize(message));
            }
        }, new byte[][]{this.serializer.serialize(this.channel)});
    }

    @Override
    public boolean has(String cacheName, Object key) {
        if (this.ehcache.has(cacheName, key)) {
            return true;
        }
        if (this.redis.has(cacheName, key)) {
            this.ehcache.put(cacheName, key, this.redis.get(cacheName, key), this.redis.getTtl(cacheName, key));
            return true;
        }
        return false;
    }

    public <T> T get(String cacheName, Object key) {
        if (this.ehcache.has(cacheName, key)) {
            return this.ehcache.get(cacheName, key);
        }
        if (this.redis.has(cacheName, key)) {
            this.ehcache.put(cacheName, key, this.redis.get(cacheName, key), this.redis.getTtl(cacheName, key));
            return this.ehcache.get(cacheName, key);
        }
        return null;
    }

    public void put(String cacheName, Object key, Object value) {
        this.ehcache.put(cacheName, key, value);
        this.redis.put(cacheName, key, value);
        this.publishMessage(EhredisMessage.ACTION.PUT, cacheName, key);
    }

    @Override
    public void put(String cacheName, Object key, Object value, Integer liveSeconds) {
        this.ehcache.put(cacheName, key, value, liveSeconds);
        this.redis.put(cacheName, key, value, liveSeconds);
        this.publishMessage(EhredisMessage.ACTION.PUT, cacheName, key);
    }

    public void remove(String cacheName, Object key) {
        this.ehcache.remove(cacheName, key);
        this.redis.remove(cacheName, key);
        this.publishMessage(EhredisMessage.ACTION.REMOVE, cacheName, key);
    }

    public void removeAll(String cacheName) {
        this.ehcache.removeAll(cacheName);
        this.redis.removeAll(cacheName);
        this.publishMessage(EhredisMessage.ACTION.REMOVEALL, cacheName, null);
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        return null;
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, Integer liveSeconds) {
        return null;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        if (this.ehcache.has(cacheName, key)) {
            return this.ehcache.getTtl(cacheName, key);
        }
        if (this.redis.has(cacheName, key)) {
            this.ehcache.put(cacheName, key, this.redis.get(cacheName, key), this.redis.getTtl(cacheName, key));
            return this.ehcache.getTtl(cacheName, key);
        }
        return null;
    }

    @Override
    public void setTtl(String cacheName, Object key, Integer seconds) {
        this.ehcache.setTtl(cacheName, key, seconds);
        this.redis.setTtl(cacheName, key, seconds);
    }

    @Override
    public Set<String> getKeys(String cacheName) {
        Set<String> keysInEhcache = this.ehcache.getKeys(cacheName);
        Set<String> keysInRedis = this.redis.getKeys(cacheName);
        keysInEhcache.addAll(keysInRedis);
        return keysInEhcache;
    }

    private void publishMessage(EhredisMessage.ACTION action, String cacheName, Object key) {
        EhredisMessage message = new EhredisMessage(this.clientId, action, cacheName, key);
        this.redis.publish(this.serializer.serialize(this.channel), this.serializer.serialize(message));
    }

    public void onMessage(String channel, Object obj) {
        EhredisMessage msg = (EhredisMessage)obj;
        if (this.clientId.equals(msg.getClientId())) {
            return;
        }
        log.info("\u6267\u884cehcache\u6570\u636e\u540c\u6b65\uff0c\u64cd\u4f5c\u7c7b\u578b\uff1a{}\uff0cCache\uff1a{}\uff0cKey\uff1a{}", new Object[]{msg.getAction(), msg.getCacheName(), msg.getKey()});
        switch (msg.getAction()) {
            case PUT: {
                this.ehcache.remove(msg.getCacheName(), msg.getKey());
                break;
            }
            case REMOVE: {
                this.ehcache.remove(msg.getCacheName(), msg.getKey());
                break;
            }
            case REMOVEALL: {
                this.ehcache.removeAll(msg.getCacheName());
            }
        }
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public void dispose() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

