/*
 * Decompiled with CFR 0.152.
 */
package itez.kit.cache;

import com.jfinal.plugin.ehcache.IDataLoader;
import com.jfinal.plugin.redis.Cache;
import com.jfinal.plugin.redis.IKeyNamingPolicy;
import com.jfinal.plugin.redis.serializer.FstSerializer;
import com.jfinal.plugin.redis.serializer.ISerializer;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.cache.ICache;
import itez.kit.log.ELogBase;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisImpl
implements ICache {
    private static final ELogBase log = ELog.log(RedisImpl.class);
    private Cache cache;
    private JedisPoolConfig config;
    private JedisPool jedisPool;

    public RedisImpl() {
        this.config = new JedisPoolConfig();
        this.init();
    }

    public RedisImpl(JedisPoolConfig jedisPoolConfig) {
        this.config = jedisPoolConfig;
        this.init();
    }

    private void init() {
        String host = EProp.RedisHost;
        String pass = EProp.RedisPass;
        int port = EProp.RedisPort;
        int timeout = 2000;
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)this.config, host, port, timeout, pass);
        ISerializer serializer = FstSerializer.me;
        IKeyNamingPolicy keyNamingPolicy = IKeyNamingPolicy.defaultKeyNamingPolicy;
        this.cache = new Cache("redis", this.jedisPool, serializer, keyNamingPolicy);
        log.info("\u521b\u5efa\u9ed8\u8ba4RedisCache\uff1aredis");
    }

    private String buildKey(String cacheName, Object key) {
        return String.format("%s>%s", cacheName, key);
    }

    @Override
    public boolean has(String cacheName, Object key) {
        return this.cache.exists((Object)this.buildKey(cacheName, key));
    }

    public <T> T get(String cacheName, Object key) {
        return (T)this.cache.get((Object)this.buildKey(cacheName, key));
    }

    public void put(String cacheName, Object key, Object value) {
        this.put(cacheName, key, value, 0);
    }

    public void remove(String cacheName, Object key) {
        this.cache.del((Object)this.buildKey(cacheName, key));
    }

    public void removeAll(String cacheName) {
        Object[] keys = this.getKeys(cacheName).toArray();
        this.cache.del(keys);
    }

    @Override
    public void put(String cacheName, Object key, Object value, Integer liveSeconds) {
        if (value == null) {
            return;
        }
        if (liveSeconds > 0) {
            this.cache.setex((Object)this.buildKey(cacheName, key), liveSeconds.intValue(), value);
        } else {
            this.cache.set((Object)this.buildKey(cacheName, key), value);
        }
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader) {
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data);
        }
        return data;
    }

    @Override
    public <T> T get(String cacheName, Object key, IDataLoader dataLoader, Integer liveSeconds) {
        if (liveSeconds <= 0) {
            return this.get(cacheName, key, dataLoader);
        }
        Object data = this.get(cacheName, key);
        if (data == null) {
            data = dataLoader.load();
            this.put(cacheName, key, data, liveSeconds);
        }
        return data;
    }

    @Override
    public Integer getTtl(String cacheName, Object key) {
        Long ttl = this.cache.ttl((Object)this.buildKey(cacheName, key));
        return ttl != null ? Integer.valueOf(ttl.intValue()) : null;
    }

    @Override
    public void setTtl(String cacheName, Object key, Integer seconds) {
        this.cache.expire((Object)this.buildKey(cacheName, key), seconds.intValue());
    }

    @Override
    public Set<String> getKeys(String cacheName) {
        return this.cache.keys(cacheName + ">*");
    }

    public JedisPoolConfig getJedisPoolConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String channel, String message) {
        Jedis jedis = this.getJedis();
        try {
            jedis.publish(channel, message);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(byte[] channel, byte[] message) {
        Jedis jedis = this.getJedis();
        try {
            jedis.publish(channel, message);
        }
        finally {
            this.returnResource(jedis);
        }
    }

    public void subscribe(JedisPubSub listener, String ... channels) {
        new Thread(() -> {
            while (true) {
                Jedis jedis = this.getJedis();
                try {
                    jedis.subscribe(listener, channels);
                    log.warn("\u8ba2\u9605\u5b8c\u6210\uff0c\u65ad\u5f00\u94fe\u63a5\u4e0e redis channels \u7684\u94fe\u63a5: {}", Arrays.toString(channels));
                }
                catch (JedisConnectionException e) {
                    log.error("\u65e0\u6cd5\u94fe\u63a5\u5230 redis channels, 1\u79d2\u540e\u91cd\u8bd5\u3002", e);
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                finally {
                    this.returnResource(jedis);
                    continue;
                }
                break;
            }
        }).start();
    }

    public void subscribe(BinaryJedisPubSub binaryListener, byte[] ... channels) {
        new Thread(() -> {
            while (true) {
                Jedis jedis = this.getJedis();
                try {
                    jedis.subscribe(binaryListener, channels);
                    log.warn("\u8ba2\u9605\u5b8c\u6210\uff0c\u65ad\u5f00\u94fe\u63a5\u4e0e redis channels \u7684\u94fe\u63a5: {}", Arrays.toString((Object[])channels));
                }
                catch (JedisConnectionException e) {
                    log.error("\u65e0\u6cd5\u94fe\u63a5\u5230 redis channels, 1\u79d2\u540e\u91cd\u8bd5\u3002", e);
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                finally {
                    this.returnResource(jedis);
                    continue;
                }
                break;
            }
        }).start();
    }

    public Jedis getJedis() {
        return this.cache.getJedis();
    }

    public void returnResource(Jedis jedis) {
        this.cache.close(jedis);
    }
}

