/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import itez.kit.EProp;
import itez.kit.EStr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EWeb {
    private static Logger log = LoggerFactory.getLogger(EWeb.class);

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (EStr.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (EStr.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (EStr.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (EStr.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (EStr.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED");
        }
        if (EStr.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_FORWARDED_FOR");
        }
        if (EStr.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_FORWARDED");
        }
        if (EStr.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getContextPath(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme()).append("://").append(request.getServerName());
        int port = request.getServerPort();
        if (port != 80 && port != 443) {
            sb.append(":").append(port);
        }
        sb.append(request.getContextPath());
        String path = sb.toString();
        return path;
    }

    public static String getFullUrl(HttpServletRequest request) {
        String resUrl = request.getRequestURL().toString();
        String params = request.getQueryString();
        if (EStr.notEmpty(params)) {
            resUrl = resUrl + "?" + params;
        }
        return resUrl;
    }

    public static String getReferer(HttpServletRequest request) {
        return request.getHeader("referer");
    }

    public static String UrlEncoder(String url) {
        String urlEncode;
        block2: {
            urlEncode = url;
            try {
                urlEncode = URLEncoder.encode(url, "UTF-8");
            }
            catch (Exception e) {
                if (!EProp.DevMode.booleanValue()) break block2;
                e.printStackTrace();
            }
        }
        return urlEncode;
    }

    public static String UrlDecoder(String url) {
        String urlDecode;
        block2: {
            urlDecode = url;
            try {
                urlDecode = URLDecoder.decode(url, "UTF-8");
            }
            catch (Exception e) {
                if (!EProp.DevMode.booleanValue()) break block2;
                e.printStackTrace();
            }
        }
        return urlDecode;
    }

    public static String getParam(HttpServletRequest request, String name) {
        String value = request.getParameter(name);
        if (null != value && !value.isEmpty()) {
            try {
                return URLDecoder.decode(value, "UTF-8").trim();
            }
            catch (UnsupportedEncodingException e) {
                log.error("decode\u5f02\u5e38\uff1a" + value);
                return value;
            }
        }
        return value;
    }

    public static Map<String, String> getParamMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enume = request.getParameterNames();
        while (enume.hasMoreElements()) {
            String name = (String)enume.nextElement();
            map.put(name, EWeb.getParam(request, name));
        }
        return map;
    }

    public static boolean isAjax(HttpServletRequest request) {
        String header = request.getHeader("X-Requested-With");
        return "XMLHttpRequest".equalsIgnoreCase(header);
    }

    public static void outPage(HttpServletResponse response, String content) {
        EWeb.outPage(response, content, "UTF-8");
    }

    public static void outPage(HttpServletResponse response, String content, String contentType) {
        if (EStr.isEmpty(contentType)) {
            contentType = "UTF-8";
        }
        response.setContentType(String.format("text/html; charset=%s", contentType));
        response.setCharacterEncoding("UTF-8");
        try {
            byte[] contentBytes = content.getBytes(contentType);
            EWeb.outPage(response, contentBytes, contentType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void outPage(HttpServletResponse response, byte[] content, String contentType) {
        if (EStr.isEmpty(contentType)) {
            contentType = "UTF-8";
        }
        response.setContentType(String.format("text/html; charset=%s", contentType));
        response.setCharacterEncoding("UTF-8");
        try {
            ServletOutputStream out = response.getOutputStream();
            out.write(content);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String requestStream(HttpServletRequest request) {
        ServletInputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            request.setCharacterEncoding("UTF-8");
            inputStream = request.getInputStream();
            inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            log.error("request.getInputStream() to String \u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.error("bufferedReader.close()\u5f02\u5e38", (Throwable)e);
                }
                bufferedReader = null;
            }
            if (null != inputStreamReader) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    log.error("inputStreamReader.close()\u5f02\u5e38", (Throwable)e);
                }
                inputStreamReader = null;
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("inputStream.close()\u5f02\u5e38", (Throwable)e);
                }
                inputStream = null;
            }
        }
    }

    public static void addCookie(HttpServletRequest request, HttpServletResponse response, String domain, String path, boolean isHttpOnly, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        if (null != domain && !domain.isEmpty()) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        if (null != path && !path.isEmpty()) {
            cookie.setPath(path);
        }
        try {
            cookie.setHttpOnly(isHttpOnly);
        }
        catch (Exception e) {
            log.error("servlet\u5bb9\u5668\u7248\u672c\u592a\u4f4e\uff0cservlet3.0\u4ee5\u524d\u4e0d\u652f\u6301\u8bbe\u7f6ecookie\u53ea\u8bfb" + e.getMessage());
        }
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static String getCookieValueByName(HttpServletRequest request, String name) {
        Cookie cookie = EWeb.getCookieByName(request, name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public static void clearCookieByName(HttpServletRequest request, HttpServletResponse response, String name) {
        Cookie cookie = EWeb.getCookieByName(request, name);
        if (cookie != null) {
            cookie.setValue(null);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = EWeb.readCookieMap(request);
        if (cookieMap.containsKey(name)) {
            Cookie cookie = cookieMap.get(name);
            return cookie;
        }
        return null;
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (int i = 0; i < cookies.length; ++i) {
                cookieMap.put(cookies[i].getName(), cookies[i]);
            }
        }
        return cookieMap;
    }

    public static String HtmltoText(String inputString) {
        String htmlStr = inputString;
        String textStr = "";
        try {
            String regEx_script = "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>";
            String regEx_style = "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>";
            String regEx_html = "<[^>]+>";
            String patternStr = "\\s+";
            Pattern p_script = Pattern.compile(regEx_script, 2);
            Matcher m_script = p_script.matcher(htmlStr);
            htmlStr = m_script.replaceAll("");
            Pattern p_style = Pattern.compile(regEx_style, 2);
            Matcher m_style = p_style.matcher(htmlStr);
            htmlStr = m_style.replaceAll("");
            Pattern p_html = Pattern.compile(regEx_html, 2);
            Matcher m_html = p_html.matcher(htmlStr);
            htmlStr = m_html.replaceAll("");
            Pattern p_ba = Pattern.compile(patternStr, 2);
            Matcher m_ba = p_ba.matcher(htmlStr);
            textStr = htmlStr = m_ba.replaceAll("");
        }
        catch (Exception e) {
            System.err.println("Html2Text: " + e.getMessage());
        }
        return textStr;
    }

    public static String getHTMLToString(String sourcestr) {
        if (sourcestr == null) {
            return "";
        }
        sourcestr = sourcestr.replaceAll("\\x26", "&amp;");
        sourcestr = sourcestr.replaceAll("\\x3c", "&lt;");
        sourcestr = sourcestr.replaceAll("\\x3e", "&gt;");
        sourcestr = sourcestr.replaceAll("\\x09", "&nbsp;&nbsp;&nbsp;&nbsp;");
        sourcestr = sourcestr.replaceAll("\\x20", "&nbsp;");
        sourcestr = sourcestr.replaceAll("\\x22", "&quot;");
        sourcestr = sourcestr.replaceAll("\r\n", "<br>");
        sourcestr = sourcestr.replaceAll("\r", "<br>");
        sourcestr = sourcestr.replaceAll("\n", "<br>");
        return sourcestr;
    }

    public static String getStringToHTML(String sourcestr) {
        if (sourcestr == null) {
            return "";
        }
        sourcestr = sourcestr.replaceAll("&amp;", "\\x26");
        sourcestr = sourcestr.replaceAll("&lt;", "\\x3c");
        sourcestr = sourcestr.replaceAll("&gt;", "\\x3e");
        sourcestr = sourcestr.replaceAll("&nbsp;&nbsp;&nbsp;&nbsp;", "\\x09");
        sourcestr = sourcestr.replaceAll("&nbsp;", "\\x20");
        sourcestr = sourcestr.replaceAll("&quot;", "\\x22");
        sourcestr = sourcestr.replaceAll("<br>", "\r\n");
        sourcestr = sourcestr.replaceAll("<br>", "\r");
        sourcestr = sourcestr.replaceAll("<br>", "\n");
        return sourcestr;
    }

    public static String getRealIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

