/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import com.google.common.collect.Maps;
import itez.kit.EStr;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.ConnectionPool;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EHttp {
    private static final Logger log = LoggerFactory.getLogger(EHttp.class);
    public static final EHttp me = new EHttp();
    private static final Charset CharSet = Charset.forName("UTF-8");
    private static final MediaType ContentType = MediaType.parse((String)"application/octet-stream");
    private final HashMap<String, List<Cookie>> cookieStore = new HashMap();
    private OkHttpClient client;

    private EHttp() {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(64);
        dispatcher.setMaxRequestsPerHost(16);
        ConnectionPool connectionPool = new ConnectionPool(32, 5L, TimeUnit.MINUTES);
        this.client = new OkHttpClient.Builder().dispatcher(dispatcher).connectionPool(connectionPool).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS).cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                EHttp.this.cookieStore.put(url.host(), cookies);
            }

            public List<Cookie> loadForRequest(HttpUrl url) {
                List cookies = (List)EHttp.this.cookieStore.get(url.host());
                return cookies != null ? cookies : new ArrayList();
            }
        }).build();
    }

    public String get(String url) {
        Request request = this.httpBuilder(Method.GET, url, null, null);
        return this.execute(request);
    }

    public String get(String url, Map<String, String> params) {
        url = this.formatGetParams(url, params);
        Request request = this.httpBuilder(Method.GET, url, null, null);
        return this.execute(request);
    }

    public String get(String url, Map<String, String> params, Map<String, String> headers) {
        url = this.formatGetParams(url, params);
        Request request = this.httpBuilder(Method.GET, url, headers, null);
        return this.execute(request);
    }

    private String formatGetParams(String url, Map<String, String> params) {
        String paramsStr = "";
        if (params != null && !params.isEmpty()) {
            paramsStr = params.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining("&"));
        }
        if (EStr.notEmpty(paramsStr)) {
            url = String.format("%s%s%s", url, Character.valueOf(url.indexOf("?") > 0 ? (char)'&' : '?'), paramsStr);
        }
        return url;
    }

    public String postJson(String url, String json) {
        MediaType mediaType = MediaType.parse((String)String.format("application/json; charset=%s", CharSet));
        RequestBody data = RequestBody.create((MediaType)mediaType, (String)json);
        Request request = this.httpBuilder(Method.POST, url, null, data);
        return this.execute(request);
    }

    public String postJson(String url, String json, Map<String, String> headers) {
        MediaType mediaType = MediaType.parse((String)String.format("application/json; charset=%s", CharSet));
        RequestBody data = RequestBody.create((MediaType)mediaType, (String)json);
        Request request = this.httpBuilder(Method.POST, url, headers, data);
        return this.execute(request);
    }

    public String postForm(String url, Map<String, String> params) {
        FormBody.Builder builder = this.getFormBody(params);
        Request request = this.httpBuilder(Method.POST, url, null, (RequestBody)builder.build());
        return this.execute(request);
    }

    public String postForm(String url, Map<String, String> params, Map<String, String> headers) {
        FormBody.Builder builder = this.getFormBody(params);
        Request request = this.httpBuilder(Method.POST, url, headers, (RequestBody)builder.build());
        return this.execute(request);
    }

    public String postFile(String url, Map<String, File> files) {
        MultipartBody.Builder builder = this.getMultiBody(files, null);
        Request request = this.httpBuilder(Method.POST, url, null, (RequestBody)builder.build());
        return this.execute(request);
    }

    public String postFile(String url, Map<String, File> files, Map<String, String> params) {
        MultipartBody.Builder builder = this.getMultiBody(files, params);
        Request request = this.httpBuilder(Method.POST, url, null, (RequestBody)builder.build());
        return this.execute(request);
    }

    public String postFile(String url, Map<String, File> files, Map<String, String> params, Map<String, String> headers) {
        MultipartBody.Builder builder = this.getMultiBody(files, params);
        Request request = this.httpBuilder(Method.POST, url, headers, (RequestBody)builder.build());
        return this.execute(request);
    }

    private FormBody.Builder getFormBody(Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder(CharSet);
        if (params != null && !params.isEmpty()) {
            params.forEach((k, v) -> builder.add(k, v));
        }
        return builder;
    }

    private MultipartBody.Builder getMultiBody(Map<String, File> files, Map<String, String> params) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        if (files != null && !files.isEmpty()) {
            files.forEach((k, v) -> builder.addFormDataPart(k, v.getName(), this.getFileBody((File)v)));
        }
        if (params != null && !params.isEmpty()) {
            params.forEach((k, v) -> builder.addFormDataPart(k, v));
        }
        return builder;
    }

    private RequestBody getFileBody(File file) {
        RequestBody fileBody = RequestBody.create((MediaType)ContentType, (File)file);
        return fileBody;
    }

    private Request httpBuilder(Method method, String url, Map<String, String> headers, RequestBody data) {
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        builder.header("User-Agent", "JWinner EHttp Kit");
        builder.addHeader("Accept-Charset", CharSet.toString());
        builder.addHeader("Accept-Language", "en-us,zh-ch");
        builder.addHeader("Content-Type", String.format("text/html; charset=%s;", CharSet));
        if (headers != null && !headers.isEmpty() && headers.size() > 0) {
            headers.forEach((k, v) -> builder.addHeader(k, v));
        }
        if (method == Method.GET) {
            builder.get();
        } else {
            builder.method(method.name(), data);
        }
        Request req = builder.build();
        return req;
    }

    private String execute(Request request) {
        String result = "";
        try {
            Response response = this.client.newCall(request).execute();
            if (response.isSuccessful()) {
                result = response.body().string();
            } else {
                log.error("\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)response.toString());
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9519\u8bef\uff1a{}", (Object)e.getMessage());
        }
        return result;
    }

    public static void main(String[] args) {
        HashMap params = Maps.newHashMap();
        params.put("uid", "abc");
        params.put("uname", "\u738b\u5a46\u5356\u74dc");
        HashMap headers = Maps.newHashMap();
        headers.put("header", "xxx");
        headers.put("cook", "cookvalue");
        HashMap files = Maps.newHashMap();
        files.put("file001", new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg"));
        files.put("file002", new File("D:\\\u516c\u53f8\u8d44\u6599\\\u4e1a\u52a1\u4ef7\u683c\u6e05\u5355.xlsx"));
        String ret = me.postFile("http://localhost/testFiles", files);
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }
}

