/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EFile {
    public static String readInRes(String filePath) {
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        String path = String.format("META-INF/resources%s", filePath);
        InputStream sm = EFile.class.getClassLoader().getResourceAsStream(path);
        return EFile.read(sm);
    }

    public static String readInJar(String filePath) {
        InputStream sm = EFile.class.getClassLoader().getResourceAsStream(filePath);
        return EFile.read(sm);
    }

    public static String read(String filePath) {
        File file = new File(filePath);
        return EFile.read(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file) {
        OutputStream baos = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            String string = EFile.read(fis);
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            EFile.close(fis, baos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream fis) {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = fis.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            String string = new String(baos.toByteArray(), "UTF-8");
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            EFile.close(fis, baos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String string) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file, false);
            fos.write(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            EFile.close(null, fos);
        }
        catch (Throwable throwable) {
            EFile.close(null, fos);
            throw throwable;
        }
        EFile.close(null, fos);
    }

    private static void close(InputStream is, OutputStream os) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static void unzip(String zipFilePath) throws IOException {
        String targetPath = zipFilePath.substring(0, zipFilePath.lastIndexOf("."));
        EFile.unzip(zipFilePath, targetPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String zipFilePath, String targetPath) throws IOException {
        block10: {
            try (ZipFile zipFile = new ZipFile(zipFilePath);){
                Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
                if (null == entryEnum) break block10;
                while (entryEnum.hasMoreElements()) {
                    OutputStream os = null;
                    InputStream is = null;
                    try {
                        ZipEntry zipEntry = entryEnum.nextElement();
                        if (zipEntry.isDirectory()) continue;
                        File targetFile = new File(targetPath + File.separator + zipEntry.getName());
                        if (!targetFile.getParentFile().exists()) {
                            targetFile.getParentFile().mkdirs();
                        }
                        os = new BufferedOutputStream(new FileOutputStream(targetFile));
                        is = zipFile.getInputStream(zipEntry);
                        byte[] buffer = new byte[4096];
                        int readLen = 0;
                        while ((readLen = is.read(buffer, 0, 4096)) > 0) {
                            os.write(buffer, 0, readLen);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) continue;
                        os.close();
                    }
                }
            }
        }
    }
}

