/*
 * Decompiled with CFR 0.152.
 */
package itez.kit;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.jfinal.log.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class EClass {
    public static Log log = Log.getLog(EClass.class);
    private static final Map<String, Object> singletons = new ConcurrentHashMap<String, Object>();
    private static Multimap<Class<?>, Method> classGetMethodsCache = ArrayListMultimap.create();
    private static Multimap<Class<?>, Method> classSetMethodsCache = ArrayListMultimap.create();

    public static ClassLoader loader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String className) {
        try {
            return EClass.loader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.error("\u65e0\u6cd5\u627e\u5230\u7c7b\uff1a" + className);
            return null;
        }
    }

    public static Class<?> forName(String className) {
        return EClass.forName(className, true);
    }

    public static Class<?> forName(String className, boolean init) {
        try {
            return Class.forName(className, init, EClass.loader());
        }
        catch (ClassNotFoundException e) {
            log.error("\u65e0\u6cd5\u627e\u5230\u7c7b\uff1a" + className);
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u521b\u5efa\u7c7b\u7684\u5b9e\u4f8b\uff1a" + clazz + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] paramsTypes, Object ... args) {
        try {
            Constructor<T> constructor = clazz.getConstructor(paramsTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u521b\u5efa\u7c7b\u7684\u5b9e\u4f8b\uff1a" + clazz + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(String clazzName) {
        try {
            Class<?> clazz = EClass.forName(clazzName, false);
            return (T)EClass.newInstance(clazz);
        }
        catch (Exception e) {
            log.error("\u65e0\u6cd5\u521b\u5efa\u7c7b\u7684\u5b9e\u4f8b\uff1a" + clazzName + "\n" + e.toString(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T singleton(Class<T> clazz) {
        String singleKey = clazz.getName();
        Object object = singletons.get(singleKey);
        if (object == null) {
            Class<T> clazz2 = clazz;
            synchronized (clazz2) {
                object = singletons.get(singleKey);
                if (object == null) {
                    object = EClass.newInstance(clazz);
                    if (object != null) {
                        singletons.put(singleKey, object);
                    } else {
                        Log.getLog(clazz).error("cannot new newInstance!!!!");
                    }
                }
            }
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T singleton(Class<T> clazz, Class<?>[] paramsTypes, Object ... args) {
        String singleKey = clazz.getName();
        String paramsKey = Arrays.stream(paramsTypes).map(cls -> cls.getName()).collect(Collectors.joining(""));
        Object object = singletons.get(singleKey = singleKey + paramsKey);
        if (object == null) {
            Class<T> clazz2 = clazz;
            synchronized (clazz2) {
                object = singletons.get(singleKey);
                if (object == null) {
                    object = EClass.newInstance(clazz, paramsTypes, args);
                    if (object != null) {
                        singletons.put(singleKey, object);
                    } else {
                        Log.getLog(clazz).error("cannot new newInstance!!!!");
                    }
                }
            }
        }
        return (T)object;
    }

    public static String getClassFullPath(Class<?> clazz) {
        return clazz.getName();
    }

    public static String getClassFullPath(Method method) {
        Class<?> clazz = EClass.getUsefulClass(method.getDeclaringClass());
        return EClass.getClassFullPath(clazz);
    }

    public static String getMethodFullPath(Method method) {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        String paramsClass = Arrays.stream(params).map(p -> p.getName()).collect(Collectors.joining(","));
        return String.format("%s(%s)", methodName, paramsClass);
    }

    public static Class<?> getUsefulClass(Class<?> clazz) {
        return clazz.getName().indexOf("$$EnhancerBy") == -1 ? clazz : clazz.getSuperclass();
    }

    public static Collection<Method> getClassGetMethods(Class<?> clazz) {
        return EClass.getClassAttrMethods(clazz, "get");
    }

    public static Collection<Method> getClassSetMethods(Class<?> clazz) {
        return EClass.getClassAttrMethods(clazz, "set");
    }

    public static Collection<Method> getClassAttrMethods(Class<?> clazz, String getOrSet) {
        Integer parameterCount = null;
        Multimap<Class<?>, Method> cache = null;
        if (getOrSet.equalsIgnoreCase("get")) {
            parameterCount = 0;
            cache = classGetMethodsCache;
        } else {
            parameterCount = 1;
            cache = classSetMethodsCache;
        }
        Collection retMethods = cache.get(clazz);
        if (retMethods == null || retMethods.isEmpty()) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (!method.getName().startsWith(getOrSet) || method.getName().length() <= 3 || method.getParameterCount() != parameterCount.intValue()) continue;
                cache.put(clazz, (Object)method);
                retMethods.add(method);
            }
        }
        return retMethods;
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, true, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

