package itez.kit.server;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.log.Log;
import com.jfinal.server.Scanner;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LocalServer_Jetty extends LocalServer {

    private static Log log = Log.getLog(LocalServer_Jetty.class);

    protected Server server;
    protected WebAppContext context;
    
    protected Integer port = 80;
    protected String webAppDir = "src/main/webapp";
    protected String contextPath = "/";
    
    protected Integer scanIntervalSeconds = 0;
	private boolean running = false;

    public LocalServer_Jetty() {
    }

    public LocalServer_Jetty(Integer port) {
    	this.port = port;
    }

    public LocalServer_Jetty(Integer port, String webAppDir) {
    	this.port = port;
    	this.webAppDir = webAppDir;;
    }

    public LocalServer_Jetty(Integer port, String webAppDir, String contextPath) {
    	this.port = port;
    	this.webAppDir = webAppDir;;
    }

    @Override
	public boolean start() {
		if (!running) {
	        try {
	            initServer();
	            server.start();
	            running = false;
	            log.info("EServer启动成功！");
	        } catch (Throwable ex) {
	            log.info("EServer启动失败！");
	            log.error(ex.toString(), ex);
	            stop();
	            return false;
	        }
		}
        return true;
    }

    protected void initServer() {
        server = new Server(port);
        server.setStopAtShutdown(true);

		SslContextFactory scf = new SslContextFactory();
        scf.setKeyStorePath("D:/JavaHome/cert/debug_itez_com_cn/214294696650114.pfx");
        scf.setKeyStoreType("PKCS12");
        scf.setKeyStorePassword("214294696650114");
        scf.setNeedClientAuth(false);
		
//        SslSelectChannelConnector ssl_connector = new SslSelectChannelConnector(scf);
//        ssl_connector.setPort(443);
//        ssl_connector.setMaxIdleTime(30000);
//        ssl_connector.setAcceptors(2);
//        ssl_connector.setAcceptQueueSize(100);
        
        ServerConnector https_conn = new ServerConnector(server, scf);
        https_conn.setPort(443);
		https_conn.setIdleTimeout(30000);
		https_conn.setAcceptQueueSize(100);
        
        server.addConnector(https_conn);

        context = new WebAppContext();
        context.setContextPath(contextPath);
        context.setDisplayName("EServer by Jetty");
        context.setClassLoader(Thread.currentThread().getContextClassLoader());
        context.setConfigurationDiscovered(true);
        context.setParentLoaderPriority(true);
        context.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
        context.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
        context.setServer(server);
        context.setResourceBase(webAppDir);
        setBaseResources(webAppDir);
        
        server.setHandler(context);
        
        if(scanIntervalSeconds > 0){
            changeClassLoader(context);
    		Scanner scanner = new Scanner(PathKit.getRootClassPath(), scanIntervalSeconds) {
    			public void onChange() {
    				try {
    					log.info("\n加载改变的代码...");
    					context.stop();
    					LocalServerClassLoader loader = new LocalServerClassLoader(context, getClassPath());
    					context.setClassLoader(loader);
    					context.start();
    					log.info("更新完成。");
    				} catch (Exception e) {
    					log.error(e.getMessage(), e);
    				}
    			}
    		};
    		log.info("开启代码变化扫码服务，每隔：" + scanIntervalSeconds + " 秒扫描一次。");
    		scanner.start();
        }
    }
    
    protected void setBaseResources(String webAppDir) {
		try {
			List<String> resources = new ArrayList<String>();
			resources.add(webAppDir);
			String[] resourcesArr = resources.toArray(new String[resources.size()]);
			context.setBaseResource(new ResourceCollection(resourcesArr));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

    @Override
    public boolean restart() {
		if (running) {
	        stop();
	        start();
		}
        return true;
    }

    @Override
    public boolean stop() {
		if (running) {
	        try {
	            server.stop();
	            running = false;
	            log.info("EServer停止成功！");
	        } catch (Exception ex) {
	            log.info("EServer停止失败！");
	            log.error(ex.toString(), ex);
	            return false;
	        }
		}
        return true;
    }

    public Server getServer() {
        return server;
    }

    public WebAppContext getContext() {
        return context;
    }

	private void changeClassLoader(WebAppContext webApp) {
		try {
			String classPath = getClassPath();
			LocalServerClassLoader jfcl = new LocalServerClassLoader(webApp, classPath);
			webApp.setClassLoader(jfcl);
		} catch (IOException e) {
			LogKit.error(e.getMessage(), e);
		}
	}
	
	private String getClassPath() {
		return System.getProperty("java.class.path");
	}

}
