package itez.kit.fileup;

import java.io.File;

import com.alibaba.fastjson.JSON;
import com.jfinal.kit.Ret;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;

import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.EUid;

public class QiNiuImpl implements IFileUp {

	private String Url; //云盘域名
	private String AK; //云盘的AK
	private String SK; //云盘的SK
	private String Bucket; //存储桶别名，例如：mybucket
	private String BZone; //存储区域名称，例如：华北。为空时自动检索存储桶所在区域

	public QiNiuImpl(){
		AK = EProp.QiNiuStoreAK;
		SK = EProp.QiNiuStoreSK;
		Bucket = EProp.QiNiuStoreBucket;
		BZone = EProp.QiNiuStoreZone;
		Url = EProp.QiNiuStoreUrl;
		
        if(!Url.endsWith("/")){
        	Url += "/";
        }
	}
	
	/**
	 * 七牛的机房区域
	 * @author netwild
	 *
	 */
	private enum StoreZone {
		EastChina("华东"), NorthChina("华北"), SouthChina("华南"), NorthAmerica("北美"), Auto("");
		private String desc;
		private Zone zone;
		private StoreZone(String desc){
	        this.desc = desc;
	        if(this.desc.equals("华东")) this.zone = Zone.zone0();
	        else if(this.desc.equals("华北")) this.zone = Zone.zone1();
	        else if(this.desc.equals("华南")) this.zone = Zone.zone2();
	        else if(this.desc.equals("北美")) this.zone = Zone.zoneNa0();
	        else this.zone = Zone.autoZone();
	    }
		public static StoreZone find(String desc){
	        if(desc.equals("华东")) return StoreZone.EastChina;
	        else if(desc.equals("华北")) return StoreZone.NorthChina;
	        else if(desc.equals("华南")) return StoreZone.SouthChina;
	        else if(desc.equals("北美")) return StoreZone.NorthAmerica;
	        else return StoreZone.Auto;
		}
	}

	@Override
	public String upload(File file) {
		String fileName = file.getName();
		String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
		String extName = fileName.substring(fileName.lastIndexOf("."));
	    String key = String.format("%s%s%s", fileIndex, EUid.generator(), extName);
	    
	    Configuration cfg = new Configuration(StoreZone.find(BZone).zone);
	    UploadManager uploadManager = new UploadManager(cfg);
	    Auth auth = Auth.create(AK, SK);
	    String upToken = auth.uploadToken(Bucket);
	    try {
	        Response response = uploadManager.put(file, key, upToken);
	        String retJson = response.bodyString();
	        Ret ret = JSON.parseObject(retJson, Ret.class);
	        return Url + ret.getStr("key");
	    } catch (QiniuException ex) {
	        Response r = ex.response;
	        System.err.println(r.toString());
	        try {
	            System.err.println(r.bodyString());
	        } catch (QiniuException ex2) {
	            //ignore
	        }
	    } catch(Exception ex){
	    	ex.printStackTrace();
	    }
		return null;
	}
	
	public static void main(String[] args) {
		QiNiuImpl fileio = new QiNiuImpl();
		File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
		String path = fileio.upload(file);
		System.out.println(path);
	}

}
