package itez.kit.fileup;

import java.io.File;
import java.nio.file.Files;

import com.jfinal.kit.PathKit;

import itez.kit.EDate;
import itez.kit.EProp;
import itez.kit.ERegex;
import itez.kit.EUid;

public class LocalImpl implements IFileUp {
	
	private String Url; //虚拟目录域名
	private String DiskPath; //虚拟目录所在硬盘位置
	
	private static final String FileSep = File.separator;
	
	public LocalImpl(){
		DiskPath = EProp.LocalFilePath;
		Url = EProp.LocalFileUrl;
		
		if(!Url.endsWith("/")){
			Url += "/";
		}
		DiskPath = formatPath(DiskPath);
    	if(!DiskPath.startsWith("/") && !DiskPath.startsWith("\\") && !ERegex.has(DiskPath, "^[A-Za-z]\\:")){
    		DiskPath = PathKit.getWebRootPath() + FileSep + DiskPath;
    	}
		if(!DiskPath.endsWith(FileSep)){
			DiskPath += FileSep;
		}
	}
	
	@Override
	public String upload(File file) {
		String fileName = file.getName();
		String fileIndex = EDate.format(EDate.getDate(), "yyyy/MM/dd/");
		String extName = fileName.substring(fileName.lastIndexOf("."));
	    String key = String.format("%s%s%s", fileIndex, EUid.generator(), extName);
	    try {
	    	String dest = formatPath(DiskPath + key);
	    	String toPathStr = dest.substring(0, dest.lastIndexOf(FileSep));
	    	File toPath = new File(toPathStr);
	    	if(!toPath.exists()) toPath.mkdirs();
	    	Files.move(file.toPath(), new File(dest).toPath());
	        return Url + key;
	    }catch (Exception e) {
	    	System.err.println(e.toString());
	    }
	    return null;
	}
	
	private String formatPath(String path){
		return path.replace("/", FileSep).replace("\\", FileSep);
	}
	
	public static void main(String[] args) {
		LocalImpl fileio = new LocalImpl();
		File file = new File("D:\\WxAppRoot\\jyt\\resources\\topHeader.jpg");
		String path = fileio.upload(file);
		System.out.println(path);
	}

}