/*
 * Decompiled with CFR 0.152.
 */
package itez.jwinner.kit;

import itez.jwinner.kit.JStr;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.util.Enumeration;

public class JUid {
    private static int counter = 0;
    private static final int MACHINE_IDENTIFIER = JUid.createMachineIdentifier();
    private static final int PROCESS_IDENTIFIER = JUid.createProcessIdentifier();

    public static final synchronized String generator() {
        if (++counter >= 1679615) {
            counter = 1;
        }
        long timestamp = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append(JStr.addPrefix(Long.toString(timestamp, 36), 8));
        sb.append(JStr.addPrefix(Integer.toString(MACHINE_IDENTIFIER + PROCESS_IDENTIFIER, 36), 6));
        sb.append(JStr.addPrefix(Integer.toString(counter, 36), 4));
        return sb.toString();
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                sb.append(JStr.parse(mac));
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (Exception e) {
            machinePiece = new SecureRandom().nextInt();
        }
        return Math.abs(machinePiece);
    }

    private static int createProcessIdentifier() {
        int processId;
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            processId = processName.contains("@") ? Integer.parseInt(processName.substring(0, processName.indexOf(64))) : processName.hashCode();
        }
        catch (Throwable t) {
            processId = new SecureRandom().nextInt();
        }
        return Math.abs(processId);
    }
}

