/*
 * Decompiled with CFR 0.152.
 */
package itez.jwinner.kit;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class JStr {
    public static final String Encoding = "UTF-8";
    public static final String FileSep = File.separator;
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    public static final Charset ISO_8859_1 = StandardCharsets.ISO_8859_1;

    public static boolean isNull(Object para) {
        return null == para;
    }

    public static boolean notNull(Object para) {
        return !JStr.isNull(para);
    }

    public static Object ifNull(Object orig, Object def) {
        return JStr.isNull(orig) ? def : orig;
    }

    public static boolean hasNull(Object ... paras) {
        if (null == paras) {
            return true;
        }
        return Arrays.stream(paras).anyMatch(JStr::isNull);
    }

    public static boolean allNull(Object ... paras) {
        if (null == paras) {
            return true;
        }
        return Arrays.stream(paras).allMatch(JStr::isNull);
    }

    public static boolean isEmpty(String str) {
        return JStr.isNull(str) || str.equals("");
    }

    public static boolean notEmpty(String str) {
        return !JStr.isEmpty(str);
    }

    public static String ifEmpty(String orig, String def) {
        return JStr.isEmpty(orig) ? def : orig;
    }

    public static boolean hasEmpty(String ... paras) {
        if (null == paras) {
            return true;
        }
        return Arrays.stream(paras).anyMatch(JStr::isEmpty);
    }

    public static boolean allEmpty(String ... paras) {
        if (null == paras) {
            return true;
        }
        return Arrays.stream(paras).allMatch(JStr::isEmpty);
    }

    public static String left(String str, int count) {
        if (JStr.isEmpty(str)) {
            return "";
        }
        int len = str.length();
        if (len < count) {
            return str;
        }
        return str.substring(0, count);
    }

    public static String right(String str, int count) {
        if (JStr.isEmpty(str)) {
            return "";
        }
        int len = str.length();
        if (len < count) {
            return str;
        }
        return str.substring(len - count);
    }

    public static String addPrefix(Integer number, int len) {
        if (JStr.isNull(number)) {
            number = 0;
        }
        return JStr.addPrefix(number + "", len);
    }

    public static String addPrefix(String str, int len) {
        return JStr.addPrefix(str, len, "0000000000");
    }

    public static String addPrefix(String str, int len, String prefix) {
        if (JStr.isNull(str)) {
            str = "";
        }
        str = prefix + str;
        return JStr.right(str, len);
    }

    public static String toLowerCaseFirst(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirst(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String concat(String ... params) {
        if (JStr.isNull(params)) {
            return "";
        }
        return String.join((CharSequence)"", params);
    }

    public static String join(List<String> list) {
        if (JStr.isNull(list)) {
            return "";
        }
        return JStr.join(list.toArray(new String[0]));
    }

    public static String join(String[] arr) {
        return JStr.join(arr, ",");
    }

    public static String join(String[] arr, String sept) {
        if (JStr.isNull(arr)) {
            return "";
        }
        return String.join((CharSequence)sept, arr);
    }

    public static String[] toArray(String str) {
        return JStr.toArray(str, ",");
    }

    public static String[] toArray(String str, String sept) {
        if (JStr.isNull(str)) {
            str = "";
        }
        return str.trim().split(sept);
    }

    public static List<String> toList(String str) {
        return JStr.toList(str, ",");
    }

    public static List<String> toList(String str, String sept) {
        String[] arr = JStr.toArray(str, sept);
        return Arrays.asList(arr);
    }

    public static String findUseful(String ... s) {
        if (JStr.isNull(s)) {
            return null;
        }
        return Arrays.stream(s).filter(JStr::notEmpty).findFirst().orElse(null);
    }

    public static int findInArr(String[] arr, String keyword) {
        if (JStr.isNull(arr)) {
            return -1;
        }
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            String item = arr[i];
            if (!JStr.notNull(item) || !item.equals(keyword)) continue;
            return i;
        }
        return -1;
    }

    public static byte[] toByte(String str) {
        return JStr.toByte(str, UTF_8);
    }

    public static byte[] toByte(String str, Charset charset) {
        if (JStr.isNull(str)) {
            return null;
        }
        return str.getBytes(charset);
    }

    public static String parse(byte[] bytes) {
        return JStr.parse(bytes, UTF_8);
    }

    public static String parse(byte[] bytes, Charset charset) {
        if (JStr.isNull(bytes)) {
            return null;
        }
        return new String(bytes, charset);
    }

    public static Integer rand(Integer min, Integer max) {
        Random rand = new Random();
        return rand.nextInt(max - min + 1) + min;
    }

    public static String ida2sqlIn(Object ... ida) {
        if (JStr.isNull(ida)) {
            ida = new String[]{""};
        }
        return Arrays.stream(ida).map(id -> String.format("'%s'", id.toString().trim())).collect(Collectors.joining(","));
    }

    public static String ids2sqlIn(String ids) {
        if (JStr.isNull(ids)) {
            ids = "";
        }
        return String.format("'%s'", ids.replace(",", "','"));
    }
}

