/*
 * Decompiled with CFR 0.152.
 */
package itez.jwinner.kit;

import itez.jwinner.kit.JRegex;
import itez.jwinner.kit.JStr;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;

public class JDate {
    public static final String PATTERN_Y = "yyyy";
    public static final String PATTERN_YM = "yyyy-MM";
    public static final String PATTERN_MD = "MM-dd";
    public static final String PATTERN_YMD = "yyyy-MM-dd";
    public static final String PATTERN_YMD_HM = "yyyy-MM-dd HH:mm";
    public static final String PATTERN_HM = "HH:mm";
    public static final String PATTERN_YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String PATTERN_YMD_HMS_S = "yyyy-MM-dd HH:mm:ss:SSS";

    public static Date getDate() {
        return new Date();
    }

    public static long getTime() {
        return new Date().getTime();
    }

    public static Date parse(String date) {
        String pattern = JDate.parsePattern(date);
        return JStr.isEmpty(pattern) ? JDate.getDate() : JDate.parse(date, pattern);
    }

    public static Date parse(String date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            return format.parse(date);
        }
        catch (Exception e) {
            return JDate.getDate();
        }
    }

    public static LocalDate date2localDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static LocalTime date2localTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalTime();
    }

    public static LocalDateTime date2localDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static Date localDate2date(LocalDate localDate) {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay(zoneId).toInstant();
        return Date.from(instant);
    }

    public static Date localTime2date(LocalTime localTime) {
        LocalDate localDate = LocalDate.now();
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        return JDate.localDateTime2date(localDateTime);
    }

    public static Date localDateTime2date(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zoneId).toInstant();
        return Date.from(instant);
    }

    public static String format(Date date) {
        return JDate.format(date, PATTERN_YMD);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Integer getYear(Date date) {
        LocalDate localDate = JDate.date2localDate(date);
        return localDate.getYear();
    }

    public static Integer getMonth(Date date) {
        LocalDate localDate = JDate.date2localDate(date);
        return localDate.getMonthValue();
    }

    public static Integer getDay(Date date) {
        LocalDate localDate = JDate.date2localDate(date);
        return localDate.getDayOfMonth();
    }

    public static Integer getDayOfYear(Date date) {
        LocalDate localDate = JDate.date2localDate(date);
        return localDate.getDayOfYear();
    }

    public static Integer getDayOfWeek(Date date) {
        LocalDate localDate = JDate.date2localDate(date);
        return localDate.getDayOfWeek().getValue();
    }

    public static Integer getHour(Date date) {
        LocalTime localTime = JDate.date2localTime(date);
        return localTime.getHour();
    }

    public static Integer getMinute(Date date) {
        LocalTime localTime = JDate.date2localTime(date);
        return localTime.getMinute();
    }

    public static Integer getSecond(Date date) {
        LocalTime localTime = JDate.date2localTime(date);
        return localTime.getSecond();
    }

    public static Duration diff(Date start, Date end) {
        LocalDateTime ld1 = JDate.date2localDateTime(start);
        LocalDateTime ld2 = JDate.date2localDateTime(end);
        Duration duration = Duration.between(ld1, ld2);
        return duration;
    }

    public static boolean isAsc(Date start, Date end) {
        LocalDateTime ld1 = JDate.date2localDateTime(start);
        LocalDateTime ld2 = JDate.date2localDateTime(end);
        return ld1.isBefore(ld2);
    }

    public static boolean isDesc(Date start, Date end) {
        LocalDateTime ld1 = JDate.date2localDateTime(start);
        LocalDateTime ld2 = JDate.date2localDateTime(end);
        return ld1.isAfter(ld2);
    }

    public static boolean isExpire(Date date) {
        return date.before(JDate.getDate());
    }

    public static Date addYear(Date date, Integer num) {
        LocalDateTime localDateTime = JDate.date2localDateTime(date);
        localDateTime.plusYears(num.intValue());
        return JDate.localDateTime2date(localDateTime);
    }

    public static Date addMonth(Date date, Integer num) {
        LocalDateTime localDateTime = JDate.date2localDateTime(date);
        localDateTime.plusMonths(num.intValue());
        return JDate.localDateTime2date(localDateTime);
    }

    public static Date addDay(Date date, Integer num) {
        LocalDateTime localDateTime = JDate.date2localDateTime(date);
        localDateTime.plusDays(num.intValue());
        return JDate.localDateTime2date(localDateTime);
    }

    public static Date addWeek(Date date, Integer num) {
        LocalDateTime localDateTime = JDate.date2localDateTime(date);
        localDateTime.plusWeeks(num.intValue());
        return JDate.localDateTime2date(localDateTime);
    }

    public static Date addHour(Date date, Integer num) {
        LocalDateTime localDateTime = JDate.date2localDateTime(date);
        localDateTime.plusHours(num.intValue());
        return JDate.localDateTime2date(localDateTime);
    }

    public static Date addMinute(Date date, Integer num) {
        LocalDateTime localDateTime = JDate.date2localDateTime(date);
        localDateTime.plusMinutes(num.intValue());
        return JDate.localDateTime2date(localDateTime);
    }

    public static Date addSecond(Date date, Integer num) {
        LocalDateTime localDateTime = JDate.date2localDateTime(date);
        localDateTime.plusSeconds(num.intValue());
        return JDate.localDateTime2date(localDateTime);
    }

    public static Date[] getMonthScope(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, calendar.getActualMinimum(5));
        Date start = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        Date end = calendar.getTime();
        return new Date[]{start, end};
    }

    private static String parsePattern(String date) {
        String pattern = null;
        if (JRegex.has(date, "^\\d{4}$")) {
            pattern = PATTERN_Y;
        } else if (JRegex.has(date, "^\\d{4}\\-\\d{1,2}$")) {
            pattern = PATTERN_YM;
        } else if (JRegex.has(date, "^\\d{4}\\-\\d{1,2}\\-\\d{1,2}$")) {
            pattern = PATTERN_YMD;
        } else if (JRegex.has(date, "^\\d{1,2}\\-\\d{1,2}$")) {
            pattern = PATTERN_MD;
        } else if (JRegex.has(date, "^\\d{1,2}\\:\\d{1,2}$")) {
            pattern = PATTERN_HM;
        } else if (JRegex.has(date, "^\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}\\:\\d{1,2}$")) {
            pattern = PATTERN_YMD_HM;
        } else if (JRegex.has(date, "^\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}\\:\\d{1,2}\\:\\d{1,2}$")) {
            pattern = PATTERN_YMD_HMS;
        } else if (JRegex.has(date, "^\\d{4}\\-\\d{1,2}\\-\\d{1,2}\\s\\d{1,2}\\:\\d{1,2}\\:\\d{1,2}\\:\\d{1,3}$")) {
            pattern = PATTERN_YMD_HMS_S;
        }
        return pattern;
    }
}

