/**
 * JUid.java
 */
package itez.jwinner.kit;

import java.net.NetworkInterface;
import java.security.SecureRandom;
import java.util.Enumeration;

/**
 * <p>
 * ID生成器
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年4月21日 下午1:33:50
 */
public class JUid {

	private static int counter = 0;
	private static final int MACHINE_IDENTIFIER = createMachineIdentifier();
	private static final int PROCESS_IDENTIFIER = createProcessIdentifier();

	public final static synchronized String generator() {
		if (++counter >= 1679615) counter = 1;
		long timestamp = System.currentTimeMillis();
		StringBuilder sb = new StringBuilder();
		sb.append(JStr.addPrefix(Long.toString(timestamp, 36), 8));
		sb.append(JStr.addPrefix(Integer.toString(MACHINE_IDENTIFIER + PROCESS_IDENTIFIER, 36), 6));
		sb.append(JStr.addPrefix(Integer.toString(counter, 36), 4));
		return sb.toString();
	}
	
	private static int createMachineIdentifier(){
		int machinePiece;
		try {
			StringBuilder sb = new StringBuilder();
			Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
			while (e.hasMoreElements()) {
				NetworkInterface ni = e.nextElement();
				byte[] mac = ni.getHardwareAddress();
				if (mac != null) {
					sb.append(JStr.parse(mac));
				}
			}
			machinePiece = sb.toString().hashCode();
		} catch (Exception e) {
			machinePiece = new SecureRandom().nextInt();
		}
		return Math.abs(machinePiece);
	}
	
	private static int createProcessIdentifier(){
		int processId;
		try {
			String processName = java.lang.management.ManagementFactory.getRuntimeMXBean().getName();
			if (processName.contains("@")) {
				processId = Integer.parseInt(processName.substring(0, processName.indexOf('@')));
			} else {
				processId = processName.hashCode();
			}
		} catch (Throwable t) {
			processId = new SecureRandom().nextInt();
		}
		return Math.abs(processId);
	}
	
}