/**
 * 
 */
package itez.jwinner.kit;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <p>
 * 正则工具类
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年4月20日 下午10:33:13
 */
public class JRegex {

	/**
	 * <p>
	 * 验证字符串str中是否含有与表达式pattern匹配的部分
	 * </p>
	 * 
	 * @param str 字符串
	 * @param pattern 表达式
	 * @return
	 */
	public static boolean has(String str, String pattern){
		Pattern keywordPattern = Pattern.compile(pattern);
		Matcher matcher = keywordPattern.matcher(str);
		return matcher.find();
	}

	/**
	 * <p>
	 * 验证字符串str是否与表达式pattern完全匹配
	 * </p>
	 * 
	 * @param str 字符串
	 * @param pattern 表达式
	 * @return
	 */
	public static boolean check(String str, String pattern){
		Pattern keywordPattern = Pattern.compile(pattern);
		Matcher matcher = keywordPattern.matcher(str);
		return matcher.matches();
	}

	/**
	 * <p>
	 * 从字符串中查找与表达式pattern匹配的部分
	 * </p>
	 * 
	 * @param str
	 * @param pattern
	 * @return
	 */
	public static String find(String str, String pattern){
		Pattern keywordPattern = Pattern.compile(pattern);
		Matcher matcher = keywordPattern.matcher(str);
		if(matcher.find()){
			return matcher.group();
		}
		return null;
	}
	
	/**
	 * <p>
	 * 从字符串中查找与表达式pattern匹配的部分中的第一个子字符串
	 * </p>
	 * <p>
	 * 要求pattern中必须含有小括号“（）”
	 * </p>
	 * 
	 * @param str
	 * @param pattern
	 * @return
	 */
	public static String findFirst(String str, String pattern){
		Pattern keywordPattern = Pattern.compile(pattern);
		Matcher matcher = keywordPattern.matcher(str);
		if(matcher.find() && matcher.groupCount() > 0){
			return matcher.group(1);
		}
		return null;
	}
	
	/**
	 * <p>
	 * 从字符串中查找与表达式pattern匹配的部分中的所有子字符串
	 * </p>
	 * <p>
	 * 要求pattern中必须含有小括号“（）”
	 * </p>
	 * 
	 * @param str
	 * @param pattern
	 * @return
	 */
	public static String[] findAll(String str, String pattern){
		Pattern keywordPattern = Pattern.compile(pattern);
		Matcher matcher = keywordPattern.matcher(str);
		List<String> group = new ArrayList<String>();
		while(matcher.find()){
			int size = matcher.groupCount();
			for(int i=1; i<=size; i++) group.add(matcher.group(i));
		}
		return group.toArray(new String[group.size()]);
	}
	
}
