/**
 * 
 */
package itez.jwinner.kit;

import java.math.BigDecimal;

/**
 * <p>
 * 浮点数工具类
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年4月21日 下午1:05:34
 */
public class JNum {

	/**
	 * 向下取整，即小于这个数的最大的那个整数
	 * @param num
	 * @return
	 */
	public static Integer floor(Object num){
		if(null == num) return null;
		String str = num.toString();
		Double dbl = Double.parseDouble(str);
		return (int)Math.floor(dbl);
	}

	/**
	 * 向上取整，即大于这个数的最小的那个整数
	 * @param num
	 * @return
	 */
	public static Integer ceil(Object num){
		if(null == num) return null;
		String str = num.toString();
		Double dbl = Double.parseDouble(str);
		return (int)Math.ceil(dbl);
	}

	/**
	 * 四舍五入取整
	 * @param num
	 * @return
	 */
	public static Integer round(Object num){
		if(null == num) return null;
		String str = num.toString();
		Double dbl = Double.parseDouble(str);
		return (int)Math.round(dbl);
	}

	/**
	 * 仅保留整数部分
	 * @param num
	 * @return
	 */
	public static Integer toInt(Object num){
		if(null == num) return null;
		String str = num.toString();
		str = str.substring(0, str.indexOf("."));
		return Integer.valueOf(str);
	}
	
	/**
	 * 浮点数加法
	 * @param v1
	 * @param v2
	 * @return
	 */
	public static Double add(Double...vs){
		BigDecimal ret = new BigDecimal(0);
		for(Double v : vs){
			BigDecimal vb = new BigDecimal(Double.toString(v));
			ret = ret.add(vb);
		}
        return ret.doubleValue();
    }
	
	/**
	 * 浮点数减法
	 * @param v1 被减数
	 * @param v2
	 * @return
	 */
	public static Double sub(Double v1, Double...vs){
		BigDecimal ret = new BigDecimal(v1.toString());
		for(Double v : vs){
			BigDecimal vb = new BigDecimal(Double.toString(v));
			ret = ret.subtract(vb);
		}
        return ret.doubleValue();
    }
	
	/**
	 * 浮点数乘法
	 * @param v1
	 * @param v2
	 * @return
	 */
	public static Double mul(Double...vs){
		BigDecimal ret = new BigDecimal(1);
		for(Double v : vs){
			BigDecimal vb = new BigDecimal(Double.toString(v));
			ret = ret.multiply(vb);
		}
        return ret.doubleValue();
    }
	
	/**
	 * 浮点数除法
	 * @param v1 被除数
	 * @param v2
	 * @return
	 */
	public static Double div(Double v1, Double...vs){
		int scale = 10; //除法运算精度
		BigDecimal ret = new BigDecimal(v1.toString());
		for(Double v : vs){
			BigDecimal vb = new BigDecimal(Double.toString(v));
			ret = ret.divide(vb, scale, BigDecimal.ROUND_HALF_UP);
		}
        return ret.doubleValue();
    }
	
}
