package itez.tp.impl.weixin.oauth;

import itez.kit.EHttp;
import itez.kit.restful.EMap;
import itez.tp.impl.weixin.ApiResult;

/**
 * <p>
 * 微信开放平台获取用户信息
 * </p>
 * 
 * 文档：https://developers.weixin.qq.com/doc/offiaccount/OA_Web_Apps/Wechat_webpage_authorization.html
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年7月1日 上午11:24:57
 */
public class UserInfoApi {
	
	private static final String url = "https://api.weixin.qq.com/sns/userinfo?lang=zh-CN";
	
	@SuppressWarnings("unchecked")
	public static ApiResult getUserInfo(String accessToken, String openId){
		final EMap paras = EMap.by("access_token", accessToken).set("openid", openId);
        String json = EHttp.me.get(url, paras);
        return new ApiResult(json);
	}
	
}
