package itez.tp.impl.weixin.oauth;

import itez.core.runtime.EContext;
import itez.kit.EStr;
import itez.tp.ApiCommon;
import itez.tp.ApiCommon.MODE;
import itez.tp.ApiCommon.TP;
import itez.tp.ApiConf;

/**
 * 微信授权登录工具类
 * @author netwild
 *
 */
public abstract class Common {

	// 非微信环境，生成登录二维码地址
	private static final String urlOp = "https://open.weixin.qq.com/connect/qrconnect?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_login&state=%s#wechat_redirect";
	
	// 微信环境，直接唤起授权地址
	private static final String urlMp = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=%s#wechat_redirect";
	
	/**
	 * 自动判断当前是否微信环境，返回对应的接口类型
	 * @return
	 */
	public static TP getOAuthEnvi(){
		return EContext.getAttr().getIsWx() ? TP.WXMP : TP.WXOP;
	}
	
	/**
	 * 自动判断当前是否微信环境，返回对应的授权地址
	 * 
	 * @param redirect
	 * @param state
	 * @return
	 */
	public static String getOAuthUrl(String redirect, String state){
		TP tp = getOAuthEnvi();
		ApiConf api = ApiCommon.getApi(tp);
		if(!api.getEnable()) return null;
		String appId = api.getVal("appId");
		if(EStr.isEmpty(appId)) return null;
		String urlTemp = tp == TP.WXMP ? urlMp : urlOp;
		String url = String.format(urlTemp, appId, redirect, state);
		return url;
	}
	
	/**
	 * 自动判断发起登录请求的地址（是否使用云端代理）
	 * @return
	 */
	public static String getOauthCaller(){
		TP tp = getOAuthEnvi();
		ApiConf api = ApiCommon.getApi(tp);
		String url = api.getAccessMode() == MODE.proxy ? "https://www.itez.com.cn" : EContext.getAttr().getSrc();
		return url.concat("/account/weixin");
	}
	
}
