package itez.tp.impl.weixin.oauth;

import java.util.concurrent.Callable;

import itez.core.util.RetryUtils;
import itez.kit.EHttp;
import itez.tp.ApiCommon;
import itez.tp.ApiCommon.TP;
import itez.tp.ApiConf;

/**
 * 获取AccessToken工具类
 * 
 * 微信公众平台：https://developers.weixin.qq.com/doc/offiaccount/OA_Web_Apps/Wechat_webpage_authorization.html
 * 微信开放平台：https://developers.weixin.qq.com/doc/oplatform/Website_App/WeChat_Login/Wechat_Login.html
 * 
 * 说明：微信授权登录（OAuth）中的AccessToken是和当前微信用户一一对应的，因此在服务端无需进行缓存处理
 * @author netwild
 *
 */
public class AccessTokenApi {

	/**
	 * 请求地址（公众平台、开放平台相同）
	 */
	private static final String createAccessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";

	/**
	 * 获取access_token
	 * 
	 * @param tp 接口类型（WXMP：公众平台，WXOP：开放平台）
	 * @param code 用户扫码之后返回的一次性授权码
	 * @return
	 */
    public static AccessToken getAccessToken(TP tp, String code) {
    	ApiConf api = ApiCommon.getApi(tp);
        return getAccessToken(api.getVal("appId"), api.getVal("appSecret"), code);
    }

    /**
     * <p>
     * 获取access_token
     * </p>
     * 
     * @param appid
     * @param secret
     * @param code
     * @return
     */
    public static AccessToken getAccessToken(String appid, String secret, String code){
    	String url = String.format(createAccessTokenUrl, appid, secret, code);
        return RetryUtils.retryOnException(3, new Callable<AccessToken>() {
            @Override
            public AccessToken call() throws Exception {
                String json = EHttp.me.get(url);
                return new AccessToken(json);
            }
        });
    }
	
}
