package itez.tp.impl.weixin.oauth;

import java.io.Serializable;
import java.util.Map;

import itez.core.util.RetryUtils.ResultCheck;
import itez.kit.EJson;

/**
 * 微信授权登录：令牌
 * 
 * 微信公众平台：https://developers.weixin.qq.com/doc/offiaccount/OA_Web_Apps/Wechat_webpage_authorization.html
 * 微信开放平台：https://developers.weixin.qq.com/doc/oplatform/Website_App/WeChat_Login/Wechat_Login.html
 * @author netwild
 *
 */
public class AccessToken implements ResultCheck, Serializable {

	private static final long serialVersionUID = 6123703537099168761L;

	/**
	 * 正确获取到 access_token 时有值
	 */
	private String access_token;    // 正确获取到 access_token 时有值
    private Integer expires_in;     // 正确获取到 access_token 时有值
	private String refresh_token;	// 刷新 access_token 时使用
	private String openid;			// 授权用户唯一标识
	private String scope;			// 用户授权的作用域，使用逗号（,）分隔
	private String unionid;			// 当且仅当该网站应用已获得该用户的userinfo授权时，才会出现该字段。

	/**
	 * 出错时有值
	 */
    private Integer errcode;        // 出错时有值
    private String errmsg;          // 出错时有值

    /**
     * 扩展参数
     */
    private Long expiredTime;       // 正确获取到 access_token 时有值，存放过期时间
    private String json;

    /**
     * 根据微信端返回的JSON实例化令牌对象
     * @param jsonStr
     */
    @SuppressWarnings("unchecked")
    public AccessToken(String json) {
        this.json = json;
        try {
            Map<String, Object> temp = EJson.parse(json, Map.class);
            access_token = (String) temp.get("access_token");
            expires_in = (Integer) temp.get("expires_in");
            refresh_token = (String) temp.get("refresh_token");
            openid = (String) temp.get("openid");
            scope = (String) temp.get("scope");
            unionid = (String) temp.get("unionid");
            errcode = (Integer) temp.get("errcode");
            errmsg = (String) temp.get("errmsg");

            if (expires_in != null) expiredTime = System.currentTimeMillis() + ((expires_in - 5) * 1000);

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    
	@Override
	public boolean matching() {
        if (errcode != null) return false;
        if (expiredTime == null) return false;
        if (expiredTime < System.currentTimeMillis()) return false;
        return access_token != null;
	}

	@Override
	public String getJson() {
		return json;
	}

	public String getAccess_token() {
		return access_token;
	}

	public Integer getExpires_in() {
		return expires_in;
	}

	public String getRefresh_token() {
		return refresh_token;
	}

	public String getOpenid() {
		return openid;
	}

	public String getScope() {
		return scope;
	}

	public String getUnionid() {
		return unionid;
	}

	public Integer getErrcode() {
		return errcode;
	}

	public String getErrmsg() {
		return errmsg;
	}

	public Long getExpiredTime() {
		return expiredTime;
	}

}
