package itez.tp.impl.weixin.mp.jssdk;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

import com.jfinal.kit.HashKit;

import itez.core.util.RetryUtils;
import itez.kit.EHttp;
import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.tp.ApiCommon;
import itez.tp.ApiCommon.TP;
import itez.tp.impl.weixin.mp.AccessTokenApi;
import itez.tp.impl.weixin.mp.Common;

/**
 * 生成签名之前必须先了解一下jsapi_ticket，jsapi_ticket是公众号用于调用微信JS接口的临时票据
 * https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&amp;type=jsapi
 *
 * 微信卡券接口签名凭证api_ticket
 * https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&amp;type=wx_card
 */
public class JsTicketApi {

    private static final String url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";

    /**
     * JSApi的类型
     *
     * jsapi: 用于分享等js-api
     * wx_card：用于卡券接口签名凭证api_ticket
     *
     */
    public enum JsApiType { jsapi, wx_card }

    /**
     *
     * http GET请求获得jsapi_ticket（有效期7200秒，开发者必须在自己的服务全局缓存jsapi_ticket）
     *
     * @param jsApiType jsApi类型
     * @return JsTicket
     */
    public static JsTicket getTicket(JsApiType jsApiType) {
        return getTicket(jsApiType, null);
    }
    
    public static JsTicket getTicket(JsApiType jsApiType, String access_token) {
    	if(EStr.isEmpty(access_token)) access_token = AccessTokenApi.getAccessTokenStr();
        String appId = ApiCommon.getApi(TP.WXMP).getVal("appId");
        String key = EStr.join(appId, ":", jsApiType.name());
        JsTicket ticket = Common.getTicket(key);
        if(ticket != null && ticket.isAvailable()) return ticket;

        // 最多三次请求
        final EMap paras = EMap.by("access_token", access_token).set("type", jsApiType.name());
        ticket = RetryUtils.retryOnException(3, new Callable<JsTicket>() {
			@Override
            @SuppressWarnings("unchecked")
            public JsTicket call() throws Exception {
            	String json = EHttp.me.get(url, paras);
                return new JsTicket(json);
            }
        });
        if (null != ticket) Common.setTicket(key, ticket);
        return ticket;
    }
    
    public static String genSignature(String noncestr, String jsapi_ticket, String timestamp, String url){
    	String part1 = "noncestr=".concat(noncestr);
    	String part2 = "jsapi_ticket=".concat(jsapi_ticket);
    	String part3 = "timestamp=".concat(timestamp);
    	String part4 = "url=".concat(url);
    	String[] arr = {part1, part2, part3, part4};
    	String str = Arrays.stream(arr).sorted().collect(Collectors.joining("&"));
    	return HashKit.sha1(str);
    }

}
