package itez.tp.impl.weixin.mp.jssdk;

import java.io.Serializable;
import java.util.Map;

import itez.core.util.RetryUtils.ResultCheck;
import itez.kit.EJson;
import itez.tp.impl.weixin.mp.ReturnCode;

/**
 * JsTicket返回封装
 */
@SuppressWarnings("unchecked")
public class JsTicket implements ResultCheck, Serializable {
	
    private static final long serialVersionUID = 6600179487477942329L;

    private String ticket; // 正确获取到 ticket 时有值
    private Integer expires_in; // 正确获取到 access_token 时有值
    private Integer errcode; // 出错时有值
    private String errmsg; // 出错时有值

    private Long expiredTime; // 正确获取到 ticket 时有值，存放过期时间
    private String json;

    public JsTicket(String jsonStr) {
        this.json = jsonStr;

        try {
            Map<String, Object> temp = EJson.parse(jsonStr, Map.class);
            ticket = (String) temp.get("ticket");
            expires_in = (Integer) temp.get("expires_in");
            errcode = (Integer) temp.get("errcode");
            errmsg = (String) temp.get("errmsg");
            if (expires_in != null) expiredTime = System.currentTimeMillis() + ((expires_in - 5) * 1000);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean matching() {
        return isAvailable();
    }

    @Override
    public String getJson() {
        return json;
    }

    public boolean isAvailable() {
        if (!isSucceed()) return false;
        if (expiredTime == null) return false;
        if (expiredTime < System.currentTimeMillis()) return false;
        return ticket != null;
    }

    public String getTicket() {
        return ticket;
    }

    public Integer getExpiresIn() {
        return expires_in;
    }

    public Integer getErrorCode() {
        return errcode;
    }

    public String getErrorMsg() {
    	StringBuffer sb = new StringBuffer(errmsg);
        if (errcode != null) {
        	sb.append("（").append(errcode);
            String result = ReturnCode.get(errcode);
            if (result != null) sb.append("：").append(result);
        	sb.append("）");
        }
        return sb.toString();
    }

    public Long getExpiredTime() {
        return expiredTime;
    }

    /**
     * APi 请求是否成功返回
     * @return boolean
     */
    public boolean isSucceed() {
        Integer errorCode = getErrorCode();
        return (errorCode == null || errorCode == 0);
    }

}
