package itez.tp.impl.weixin.mp;

import java.util.Map;

import com.google.common.collect.Maps;

import itez.tp.impl.weixin.mp.jssdk.JsTicket;

/**
 * 微信公众号工具类
 * @author netwild
 *
 */
public abstract class Common {

	/**
	 * JsTicket服务端缓存
	 */
	private static Map<String, JsTicket> JsTicketCache = Maps.newConcurrentMap();
	
    public static JsTicket getTicket(String key) {
        return JsTicketCache.get(key);
    }

    public static void setTicket(String key, JsTicket jsonValue) {
    	JsTicketCache.put(key, jsonValue);
    }

    public static void removeTicket(String key) {
    	JsTicketCache.remove(key);
    }

	/**
	 * AccessToken服务端缓存
	 */
	private static Map<String, AccessToken> tokenCache = Maps.newConcurrentMap();
	
    public static AccessToken getToken(String key) {
        return tokenCache.get(key);
    }

    public static void setToken(String key, AccessToken jsonValue) {
    	tokenCache.put(key, jsonValue);
    }

    public static void removeToken(String key) {
    	tokenCache.remove(key);
    }
	
}
