package itez.tp.impl.weixin.mp;

import java.io.Serializable;
import java.util.Map;

import itez.core.util.RetryUtils.ResultCheck;
import itez.kit.EJson;

/**
 * 封装 access_token
 */
@SuppressWarnings("unchecked")
public class AccessToken implements ResultCheck, Serializable {
	
	private static final long serialVersionUID = 2013966423232570925L;
	
	private String access_token;    // 正确获取到 access_token 时有值
    private Integer expires_in;     // 正确获取到 access_token 时有值
    private Integer errcode;        // 出错时有值
    private String errmsg;          // 出错时有值

    private Long expiredTime;       // 正确获取到 access_token 时有值，存放过期时间
    private String json;

    public AccessToken(String jsonStr) {
        this.json = jsonStr;
        try {
            Map<String, Object> temp = EJson.parse(jsonStr, Map.class);
            access_token = (String) temp.get("access_token");
            expires_in = (Integer) temp.get("expires_in");
            errcode = (Integer) temp.get("errcode");
            errmsg = (String) temp.get("errmsg");
            if (expires_in != null) expiredTime = System.currentTimeMillis() + ((expires_in -5) * 1000);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean matching() {
        return isAvailable();
    }

    @Override
    public String getJson() {
        return json;
    }

    public boolean isAvailable() {
        if (errcode != null) return false;
        if (expiredTime == null) return false;
        if (expiredTime < System.currentTimeMillis()) return false;
        return access_token != null;
    }

    public String getAccessToken() {
        return access_token;
    }

    public Integer getExpiresIn() {
        return expires_in;
    }

    public Long getExpiredTime() {
        return expiredTime;
    }

    public Integer getErrorCode() {
        return errcode;
    }

    public String getErrorMsg() {
    	StringBuffer sb = new StringBuffer(errmsg);
        if (errcode != null) {
        	sb.append("（").append(errcode);
            String result = ReturnCode.get(errcode);
            if (result != null) sb.append("：").append(result);
        	sb.append("）");
        }
        return sb.toString();
    }
}
