package itez.tp.impl.weishao;

import itez.kit.EStr;
import itez.tp.ApiCommon;
import itez.tp.ApiCommon.TP;
import itez.tp.ApiConf;

/**
 * 微信授权登录工具类
 * @author netwild
 *
 */
public abstract class Common {

	// 用户登录授权地址
	private static final String OAuthUrl = "https://api.weishao.com.cn/oauth/authorize?client_id=%s&redirect_uri=%s&response_type=code&scope=base_api&state=%s&domain=%s";
	
	/**
	 * 返回对应的接口类型
	 * @return
	 */
	public static TP getOAuthEnvi(){
		return TP.WSOP;
	}
	
	/**
	 * 返回对应的授权地址
	 * @param domain
	 * @param redirect
	 * @param state
	 * @return
	 */
	public static String getOAuthUrl(String redirect, String state, String domain){
		TP tp = getOAuthEnvi();
		ApiConf api = ApiCommon.getApi(tp);
		if(!api.getEnable()) return null;
		String appId = api.getVal("clientId");
		if(EStr.isEmpty(appId)) return null;
		String url = String.format(OAuthUrl, appId, redirect, state, domain);
		return url;
	}
	
}
