package itez.tp.impl.weishao;

import java.util.concurrent.Callable;

import itez.core.util.RetryUtils;
import itez.kit.EHttp;
import itez.kit.restful.EMap;
import itez.tp.ApiCommon;
import itez.tp.ApiCommon.TP;
import itez.tp.ApiConf;

/**
 * 认证并获取 access_token API
 * https://developers.weixin.qq.com/doc/oplatform/Website_App/WeChat_Login/Wechat_Login.html
 */
@SuppressWarnings("unused")
public class AccessTokenApi {

	// 获取新的access_token
	private static String creAccessTokenUrl = "https://api.weishao.com.cn/oauth/token";
	// 刷新access_token
    private static String refAccessTokenUrl = "https://api.weishao.com.cn/oauth/token";

    /**
     * <p>
     * 获取access_token
     * </p>
     * 
     * @param code 用户扫码之后返回的一次性授权码
     * @return
     */
    public static AccessToken getAccessToken(String code, String url) {
    	ApiConf api = ApiCommon.getApi(TP.WSOP);
    	String clientId = api.getVal("clientId");
    	String clientSecret = api.getVal("clientSecret");
        return getAccessToken(clientId, clientSecret, code, url);
    }

    /**
     * <p>
     * 获取access_token
     * </p>
     * 
     * @param appid
     * @param secret
     * @param code
     * @return
     */
    public static AccessToken getAccessToken(String clientId, String clientSecret, String code, String url){
    	EMap paras = EMap.create();
    	paras.set("grant_type", "authorization_code");
    	paras.set("client_id", clientId);
    	paras.set("client_secret", clientSecret);
    	paras.set("code", code);
    	paras.set("redirect_uri", url);
        return RetryUtils.retryOnException(3, new Callable<AccessToken>() {
            @SuppressWarnings("unchecked")
			@Override
            public AccessToken call() throws Exception {
                String json = EHttp.me.postForm(creAccessTokenUrl, paras);
                return new AccessToken(json);
            }
        });
    }

}
